/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.commands;

import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public abstract class AbstractSubCommand {
    private final String name;
    private final List<String> aliases = new ArrayList<String>();
    private final PluginPermission permission;
    private final boolean playerOnly;
    private String invalidPermissionMessage;

    protected AbstractSubCommand(String string, PluginPermission pluginPermission, boolean bl) {
        this.name = string.toLowerCase();
        this.permission = pluginPermission;
        this.playerOnly = bl;
    }

    public abstract void onCommand(Player var1, String[] var2);

    public List<String> onTabComplete(Player player, String[] stringArray) {
        return Collections.emptyList();
    }

    protected final void addAliases(String ... stringArray) {
        for (String string : stringArray) {
            this.aliases.add(string.toLowerCase());
        }
    }

    protected boolean checkPermission(Player player, PluginPermission pluginPermission, String string) {
        if (!pluginPermission.hasPermission((Permissible)player)) {
            StringUtil.msgSend(player, string);
            return false;
        }
        return true;
    }

    protected boolean checkPermission(Player player, PluginPermission pluginPermission) {
        return this.checkPermission(player, pluginPermission, MessagesFile.getInstance().getInvalidPermission().toString());
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public PluginPermission getPermission() {
        return this.permission;
    }

    public boolean isPlayerOnly() {
        return this.playerOnly;
    }

    public String getInvalidPermissionMessage() {
        return this.invalidPermissionMessage;
    }

    public void setInvalidPermissionMessage(String string) {
        this.invalidPermissionMessage = string;
    }
}

