/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.commands;

import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.commands.AbstractSubCommand;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public abstract class AbstractCommand
implements TabExecutor {
    private final String command;
    private final List<AbstractSubCommand> subCommands = new ArrayList<AbstractSubCommand>();
    private Player player;

    protected AbstractCommand(String string) {
        this.command = string;
    }

    protected abstract void onCommand(Player var1, String var2, String[] var3);

    protected void addSubCommands(AbstractSubCommand ... abstractSubCommandArray) {
        this.subCommands.addAll(Arrays.asList(abstractSubCommandArray));
    }

    protected boolean checkPermission(PluginPermission pluginPermission, String string) {
        if (this.player == null || pluginPermission == null) {
            return true;
        }
        if (!pluginPermission.hasPermission((Permissible)this.player)) {
            StringUtil.msgSend(this.player, string);
            return false;
        }
        return true;
    }

    public final boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        Player player = this.player = commandSender instanceof Player ? (Player)commandSender : null;
        if (!PluginPermission.COMMANDS.hasPermission((Permissible)this.player)) {
            MessagesFile.getInstance().getNoCommands().send(this.player);
            return true;
        }
        if (stringArray.length != 0) {
            for (AbstractSubCommand abstractSubCommand : this.subCommands) {
                if (!abstractSubCommand.getAliases().contains(stringArray[0].toLowerCase()) && !abstractSubCommand.getName().equalsIgnoreCase(stringArray[0])) continue;
                if (!this.checkPermission(abstractSubCommand.getPermission(), abstractSubCommand.getInvalidPermissionMessage() == null ? MessagesFile.getInstance().getInvalidPermission().toString() : abstractSubCommand.getInvalidPermissionMessage())) {
                    return true;
                }
                if (abstractSubCommand.isPlayerOnly() && this.player == null) {
                    MessagesFile.getInstance().getPlayerOnly().send();
                    return true;
                }
                abstractSubCommand.onCommand(this.player, stringArray);
                return true;
            }
        }
        this.onCommand(this.player, string, stringArray);
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string2, String[] stringArray) {
        if (stringArray.length > 1) {
            return this.subCommands.stream().filter(abstractSubCommand -> abstractSubCommand.getPermission() != null && abstractSubCommand.getPermission().hasPermission((Permissible)this.player) && (abstractSubCommand.getName().equalsIgnoreCase(stringArray[0]) || abstractSubCommand.getAliases().stream().anyMatch(string -> string.equalsIgnoreCase(stringArray[0])))).findFirst().map(abstractSubCommand -> abstractSubCommand.onTabComplete(commandSender instanceof Player ? (Player)commandSender : null, Arrays.copyOfRange(stringArray, 1, stringArray.length))).orElse(null);
        }
        return PluginPermission.COMMANDS.hasPermission((Permissible)this.player) ? this.subCommands.stream().filter(abstractSubCommand -> abstractSubCommand.getPermission() != null && abstractSubCommand.getPermission().hasPermission((Permissible)this.player)).map(AbstractSubCommand::getName).filter(string -> string.startsWith(stringArray[0].toLowerCase())).collect(Collectors.toList()) : null;
    }

    protected String getCommand() {
        return this.command;
    }

    protected List<AbstractSubCommand> getSubCommands() {
        return this.subCommands;
    }
}

