/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.arrow;

import com.live.bemmamin.gps.Enums;
import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.arrow.AbstractArrow;
import com.live.bemmamin.gps.files.CrashSafetyFile;
import com.live.bemmamin.gps.playerdata.PlayerData;
import com.live.bemmamin.gps.utils.ActionbarUtil;
import com.live.bemmamin.gps.utils.TagUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.EulerAngle;

public class ResourcePackArrow
extends AbstractArrow {
    public ResourcePackArrow(PlayerData playerData) {
        super(playerData);
    }

    @Override
    public void updateArrow(LinkedHashMap<Location, Enums.ComponentType> linkedHashMap) {
        if (this.getComponents().isEmpty() && !Vars.getInstance().isDisableArrow()) {
            this.setComponents(linkedHashMap);
            this.spawnNameTag();
            this.move(linkedHashMap);
            return;
        }
        this.setComponents(linkedHashMap);
        this.move(linkedHashMap);
    }

    private ItemStack getArrowItem() {
        ItemStack itemStack = new ItemStack(Vars.getInstance().getResourcePackArrowMaterial(), 1, Vars.getInstance().getResourcePackArrowDurability());
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (Stream.of("1.8", "1.9", "1.10", "1.11", "1.12").noneMatch(Bukkit.getVersion()::contains)) {
            itemMeta.setUnbreakable(true);
        } else {
            itemMeta.spigot().setUnbreakable(true);
        }
        if (Stream.of("1.8", "1.9", "1.10", "1.11", "1.12", "1.13").noneMatch(Bukkit.getVersion()::contains) && Vars.getInstance().getResourcePackCustomModelData() != 0) {
            try {
                Method method = itemMeta.getClass().getMethod("setCustomModelData", Integer.class);
                method.setAccessible(true);
                method.invoke((Object)itemMeta, Vars.getInstance().getResourcePackCustomModelData());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    @Override
    protected ArmorStand spawnNameTag() {
        Location location = new ArrayList<Location>(this.getComponents().keySet()).get(0);
        location.getChunk().isLoaded();
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
        TagUtil.tagEntity((Entity)armorStand);
        armorStand.setGravity(false);
        armorStand.setVisible(false);
        if (!Vars.getInstance().getArrowName().isEmpty() && !Vars.getInstance().isUseActionbar()) {
            armorStand.setCustomName(this.getArrowName());
            armorStand.setCustomNameVisible(true);
        }
        armorStand.setHelmet(this.getArrowItem());
        Vars.getInstance().getStandMap().put(armorStand.getEntityId(), armorStand);
        this.getPlayerData().getStands().add(armorStand);
        CrashSafetyFile.getInstance().saveUUIDs(Collections.singletonList(armorStand));
        return armorStand;
    }

    @Override
    protected void move(LinkedHashMap<Location, Enums.ComponentType> linkedHashMap) {
        Object object;
        Location location = new ArrayList<Location>(linkedHashMap.keySet()).get(0);
        if (!Vars.getInstance().isDisableArrow()) {
            object = this.getPlayerData().getStands().get(0);
            if (object.isDead()) {
                Vars.getInstance().getStandMap().remove(object.getEntityId());
                this.getPlayerData().getStands().set(0, this.spawnNameTag());
            }
            boolean bl = location.getPitch() < 0.0f;
            float f = Math.abs(location.getPitch());
            object.setHeadPose(new EulerAngle(bl ? -Math.toRadians(f) : Math.toRadians(f), 0.0, 0.0));
            object.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        }
        if (!Vars.getInstance().isDisableArrow()) {
            if (this.getPlayerData().getStands().get(0).isDead()) {
                Vars.getInstance().getStandMap().remove(this.getPlayerData().getStands().get(0).getEntityId());
                this.getPlayerData().getStands().set(0, this.spawnNameTag());
            } else {
                this.getPlayerData().getStands().get(0).teleport(location);
                object = this.getArrowName();
                if (!Vars.getInstance().isUseActionbar()) {
                    this.getPlayerData().getStands().get(0).setCustomName((String)object);
                } else {
                    ActionbarUtil.sendMessage(this.getPlayerData().getPlayer(), (String)object, true);
                }
            }
        } else {
            ActionbarUtil.sendMessage(this.getPlayerData().getPlayer(), this.getArrowName(), true);
            return;
        }
        if (Main.getEntityHider() != null) {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                if (this.getPlayerData().getPlayer() == player) {
                    Main.getEntityHider().showEntity(player, (Entity)this.getPlayerData().getStands().get(0));
                    continue;
                }
                Main.getEntityHider().hideEntity(player, (Entity)this.getPlayerData().getStands().get(0));
            }
        }
    }
}

