/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.arrow;

import com.live.bemmamin.gps.Enums;
import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.arrow.AbstractArrow;
import com.live.bemmamin.gps.files.CrashSafetyFile;
import com.live.bemmamin.gps.playerdata.PlayerData;
import com.live.bemmamin.gps.utils.ActionbarUtil;
import com.live.bemmamin.gps.utils.ParticleUtil;
import com.live.bemmamin.gps.utils.TagUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ParticleArrow
extends AbstractArrow {
    public ParticleArrow(PlayerData playerData) {
        super(playerData);
        this.getPlayerData().setAbstractArrow(this);
    }

    @Override
    public void updateArrow(LinkedHashMap<Location, Enums.ComponentType> linkedHashMap) {
        if (this.getComponents().isEmpty() && !Vars.getInstance().isDisableArrow()) {
            this.setComponents(linkedHashMap);
            this.getPlayerData().getStands().add(this.spawnNameTag());
            return;
        }
        this.setComponents(linkedHashMap);
        this.move(linkedHashMap);
    }

    @Override
    protected void move(LinkedHashMap<Location, Enums.ComponentType> linkedHashMap) {
        ArrayList<Location> arrayList = new ArrayList<Location>(linkedHashMap.keySet());
        this.spawnParticleArrow(linkedHashMap.keySet());
        String string = this.getArrowName();
        if (!Vars.getInstance().isDisableArrow()) {
            if (this.getPlayerData().getStands().get(0).isDead()) {
                Vars.getInstance().getStandMap().remove(this.getPlayerData().getStands().get(0).getEntityId());
                this.getPlayerData().getStands().set(0, this.spawnNameTag());
            } else {
                this.getPlayerData().getStands().get(0).teleport((Location)arrayList.get(linkedHashMap.size() - 1));
                if (!Vars.getInstance().isUseActionbar()) {
                    this.getPlayerData().getStands().get(0).setCustomName(string);
                } else {
                    ActionbarUtil.sendMessage(this.getPlayerData().getPlayer(), string, true);
                }
            }
        } else {
            ActionbarUtil.sendMessage(this.getPlayerData().getPlayer(), string, true);
            return;
        }
        this.SetEntityVisibilityForPlayer();
    }

    @Override
    protected ArmorStand spawnNameTag() {
        Location location = new ArrayList<Location>(this.getComponents().keySet()).get(this.getComponents().keySet().size() - 1);
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
        TagUtil.tagEntity((Entity)armorStand);
        armorStand.setGravity(false);
        armorStand.setVisible(false);
        if (!Vars.getInstance().getArrowName().isEmpty() && !Vars.getInstance().isUseActionbar()) {
            armorStand.setCustomName(this.getArrowName());
            armorStand.setCustomNameVisible(true);
        }
        Vars.getInstance().getStandMap().put(armorStand.getEntityId(), armorStand);
        if (Main.getEntityHider() != null) {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                if (this.getPlayerData().getPlayer() == player) {
                    Main.getEntityHider().showEntity(player, (Entity)armorStand);
                    continue;
                }
                Main.getEntityHider().hideEntity(player, (Entity)armorStand);
            }
        }
        CrashSafetyFile.getInstance().saveUUIDs(Collections.singletonList(armorStand));
        return armorStand;
    }

    private void spawnParticleArrow(Set<Location> set) {
        for (Location location : set) {
            new ParticleUtil(this.getPlayerData().getPlayer()).spawnParticleCube(location);
        }
    }
}

