/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.arrow;

import com.live.bemmamin.gps.Enums;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.arrow.AbstractArrow;
import com.live.bemmamin.gps.files.CrashSafetyFile;
import com.live.bemmamin.gps.playerdata.PlayerData;
import com.live.bemmamin.gps.utils.ActionbarUtil;
import com.live.bemmamin.gps.utils.TagUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class EntityArrow
extends AbstractArrow {
    public EntityArrow(PlayerData playerData) {
        super(playerData);
        this.getPlayerData().setAbstractArrow(this);
    }

    private void spawnArrow() {
        for (Location location : this.getComponents().keySet()) {
            this.getPlayerData().getStands().add(this.spawnStand(location));
        }
        this.getPlayerData().getStands().add(this.spawnNameTag());
        CrashSafetyFile.getInstance().saveUUIDs(this.getPlayerData().getStands());
        this.SetEntityVisibilityForPlayer();
    }

    private ArmorStand spawnStand(Location location) {
        location.getChunk().isLoaded();
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
        TagUtil.tagEntity((Entity)armorStand);
        armorStand.setSmall(true);
        armorStand.setHelmet(new ItemStack(Vars.getInstance().getMaterial(), 1, (short)Vars.getInstance().getData()));
        armorStand.setGravity(false);
        armorStand.setVisible(false);
        armorStand.setMarker(true);
        Vars.getInstance().getStandMap().put(armorStand.getEntityId(), armorStand);
        return armorStand;
    }

    @Override
    protected ArmorStand spawnNameTag() {
        Location location = this.getPlayerData().getStands().get(this.getPlayerData().getStands().size() - 1).getLocation();
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
        TagUtil.tagEntity((Entity)armorStand);
        armorStand.setGravity(false);
        armorStand.setVisible(false);
        if (!Vars.getInstance().getArrowName().isEmpty() && !Vars.getInstance().isUseActionbar()) {
            armorStand.setCustomName(this.getArrowName());
            armorStand.setCustomNameVisible(true);
        }
        Vars.getInstance().getStandMap().put(armorStand.getEntityId(), armorStand);
        return armorStand;
    }

    @Override
    public void updateArrow(LinkedHashMap<Location, Enums.ComponentType> linkedHashMap) {
        if (this.getComponents().isEmpty() && !Vars.getInstance().isDisableArrow()) {
            this.setComponents(linkedHashMap);
            this.spawnArrow();
            this.move(linkedHashMap);
            return;
        }
        this.setComponents(linkedHashMap);
        this.move(linkedHashMap);
    }

    @Override
    protected void move(LinkedHashMap<Location, Enums.ComponentType> linkedHashMap) {
        ArrayList<Location> arrayList = new ArrayList<Location>(linkedHashMap.keySet());
        ArrayList<Enums.ComponentType> arrayList2 = new ArrayList<Enums.ComponentType>(linkedHashMap.values());
        if (!Vars.getInstance().isDisableArrow()) {
            for (int i = 0; i < this.getPlayerData().getStands().size() - 1; ++i) {
                ArmorStand armorStand = this.getPlayerData().getStands().get(i);
                if (armorStand.isDead()) {
                    Vars.getInstance().getStandMap().remove(armorStand.getEntityId());
                    this.getPlayerData().getStands().set(i, this.spawnStand((Location)arrayList.get(i)));
                    continue;
                }
                boolean bl = (double)((Location)arrayList.get(i)).getPitch() >= 22.5 || (double)((Location)arrayList.get(i)).getPitch() <= -22.5;
                boolean bl2 = ((Location)arrayList.get(i)).getPitch() < 0.0f;
                float f = Math.abs(((Location)arrayList.get(i)).getPitch());
                switch ((Enums.ComponentType)((Object)arrayList2.get(i))) {
                    case SHAFT_PART: {
                        armorStand.setHeadPose(new EulerAngle(bl2 ? -Math.toRadians(f) : Math.toRadians(f), 0.0, 0.0));
                        break;
                    }
                    case HEAD_PART_RIGHT: {
                        armorStand.setHeadPose(new EulerAngle(!bl ? (bl2 ? -Math.toRadians(f * 0.9f) : Math.toRadians(f * 0.9f)) : (bl2 ? -Math.toRadians(f * 0.9f) + Math.toRadians(f - 22.5f) : Math.toRadians(f * 0.9f) - Math.toRadians(f - 22.5f)), -Math.toRadians(f), bl2 ? -Math.toRadians(f * 1.8f) : Math.toRadians(f * 1.8f)));
                        break;
                    }
                    case HEAD_PART_LEFT: {
                        armorStand.setHeadPose(new EulerAngle(!bl ? (bl2 ? -Math.toRadians(f * 0.9f) : Math.toRadians(f * 0.9f)) : (bl2 ? -Math.toRadians(f * 0.9f) + Math.toRadians(f - 22.5f) : Math.toRadians(f * 0.9f) - Math.toRadians(f - 22.5f)), Math.toRadians(f), bl2 ? Math.toRadians(f * 1.8f) : -Math.toRadians(f * 1.8f)));
                    }
                }
                armorStand.teleport((Location)arrayList.get(i), PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
        }
        if (!Vars.getInstance().isDisableArrow()) {
            if (this.getPlayerData().getStands().get(this.getPlayerData().getStands().size() - 1).isDead()) {
                Vars.getInstance().getStandMap().remove(this.getPlayerData().getStands().get(this.getPlayerData().getStands().size() - 1).getEntityId());
                this.getPlayerData().getStands().set(this.getPlayerData().getStands().size() - 1, this.spawnNameTag());
            } else {
                this.getPlayerData().getStands().get(this.getPlayerData().getStands().size() - 1).teleport((Location)arrayList.get(linkedHashMap.size() - 1));
                if (!Vars.getInstance().isUseActionbar()) {
                    this.getPlayerData().getStands().get(this.getPlayerData().getStands().size() - 1).setCustomName(this.getArrowName());
                } else {
                    ActionbarUtil.sendMessage(this.getPlayerData().getPlayer(), this.getArrowName(), true);
                }
            }
        } else {
            ActionbarUtil.sendMessage(this.getPlayerData().getPlayer(), this.getArrowName(), true);
            return;
        }
        this.SetEntityVisibilityForPlayer();
    }
}

