/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.arrow;

import com.live.bemmamin.gps.Enums;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.playerdata.PlayerData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public final class ArrowCreator {
    public static LinkedHashMap<Location, Enums.ComponentType> computeLocations(Player player, Location location) {
        Location location2 = ArrowCreator.getLocation(player, location);
        Vector vector = location2.getDirection().multiply(Vars.getInstance().getArrowDensity());
        location2.subtract(location2.getDirection().multiply(Vars.getInstance().getArrowLength() / 2.0));
        LinkedHashMap<Location, Enums.ComponentType> linkedHashMap = new LinkedHashMap<Location, Enums.ComponentType>();
        for (double d = 0.0; d < Vars.getInstance().getArrowLength(); d += Vars.getInstance().getArrowDensity()) {
            Location location3 = location2.add(vector);
            linkedHashMap.put(location3.clone(), Enums.ComponentType.SHAFT_PART);
        }
        LinkedHashMap<Location, Enums.ComponentType> linkedHashMap2 = ArrowCreator.arrowHead((Location)new ArrayList(linkedHashMap.keySet()).get(linkedHashMap.keySet().size() - 1));
        linkedHashMap.remove(new ArrayList(linkedHashMap.keySet()).get(linkedHashMap.size() - 1));
        linkedHashMap.putAll(linkedHashMap2);
        return linkedHashMap;
    }

    private static LinkedHashMap<Location, Enums.ComponentType> arrowHead(Location location) {
        LinkedHashMap<Location, Enums.ComponentType> linkedHashMap = new LinkedHashMap<Location, Enums.ComponentType>();
        for (Integer n : Arrays.asList(45, -45)) {
            Location location2 = location.clone();
            double d = (double)location2.getPitch() - (double)location2.getPitch() * 0.5;
            double d2 = n > 0 ? (double)location2.getPitch() * 0.45 : -((double)location2.getPitch() * 0.45);
            double d3 = (double)(location2.getYaw() + (float)n.intValue()) + (d < 0.0 ? -d2 : d2);
            location2.setPitch((float)d);
            location2.setYaw((float)d3);
            Vector vector = location2.getDirection().multiply(Vars.getInstance().getArrowDensity());
            location2.subtract(location2.getDirection().multiply(Vars.getInstance().getHeadLength() + Vars.getInstance().getHeadOffset()));
            for (double d4 = 0.0; d4 < Vars.getInstance().getHeadLength(); d4 += Vars.getInstance().getArrowDensity()) {
                Location location3 = location2.add(vector);
                linkedHashMap.put(location3.clone(), n > 0 ? Enums.ComponentType.HEAD_PART_RIGHT : Enums.ComponentType.HEAD_PART_LEFT);
            }
        }
        return linkedHashMap;
    }

    public static LinkedHashMap<Location, Enums.ComponentType> resourcePackArrowLocation(Player player, Location location) {
        Location location2 = ArrowCreator.getLocation(player, location);
        LinkedHashMap<Location, Enums.ComponentType> linkedHashMap = new LinkedHashMap<Location, Enums.ComponentType>();
        linkedHashMap.put(location2, Enums.ComponentType.RESOURCE_PACK_PART);
        return linkedHashMap;
    }

    private static Location getLocation(Player player, Location location) {
        PlayerData playerData = PlayerData.getPlayerData(player);
        if (playerData.getPath() != null) {
            playerData.getArrow().setRemainingDistanceToTarget(playerData.getPath().calculateDistance(null));
            if (playerData.getArrow().getRemainingDistanceToTarget() >= playerData.getArrow().getTotalDistanceToTarget()) {
                playerData.getArrow().setTotalDistanceToTarget(playerData.getArrow().getRemainingDistanceToTarget());
            }
        }
        Vector vector = location.toVector();
        Location location2 = new Location(player.getWorld(), (double)player.getLocation().getBlockX() + 0.5, player.getLocation().getY() + PlayerData.getPlayerData(player).getArrowVerticalOffsetFromPlayer(), (double)player.getLocation().getBlockZ() + 0.5);
        location2.setDirection(Vars.getInstance().isFixedArrowHeight() ? player.getLocation().getDirection().setY(0) : player.getLocation().getDirection());
        Vector vector2 = location2.getDirection().multiply(playerData.getArrowHorizontalDistanceFromPlayer() + playerData.getMovementSpeed() * 4.0);
        Location location3 = location2.add(vector2);
        location3.setDirection(vector.subtract(player.getLocation().toVector()));
        return location3;
    }
}

