/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.arrow;

import com.live.bemmamin.gps.Enums;
import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.playerdata.PlayerData;
import com.live.bemmamin.gps.utils.StringUtil;
import java.util.LinkedHashMap;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public abstract class AbstractArrow {
    private PlayerData playerData;
    private LinkedHashMap<Location, Enums.ComponentType> components = new LinkedHashMap();
    private double remainingDistanceToTarget = 0.0;
    private double totalDistanceToTarget = 0.0;

    AbstractArrow(PlayerData playerData) {
        this.playerData = playerData;
        this.playerData.setAbstractArrow(this);
    }

    public String getArrowName() {
        String string = StringUtil.translate(Vars.getInstance().getArrowName().replace("%distance%", StringUtil.formatDouble(this.remainingDistanceToTarget)).replace("%distanceRounded%", StringUtil.formatDouble(this.remainingDistanceToTarget).substring(0, StringUtil.formatDouble(this.remainingDistanceToTarget).length() - 3)).replace("%distanceTenth%", StringUtil.formatDouble(this.remainingDistanceToTarget).substring(0, StringUtil.formatDouble(this.remainingDistanceToTarget).length() - 1)));
        if (Main.isPlaceHolderAPIEnabled()) {
            string = PlaceholderAPI.setPlaceholders((Player)this.playerData.getPlayer(), (String)string);
        }
        return string;
    }

    public abstract void updateArrow(LinkedHashMap<Location, Enums.ComponentType> var1);

    protected void SetEntityVisibilityForPlayer() {
        if (Main.getEntityHider() == null) {
            return;
        }
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            for (ArmorStand armorStand : this.getPlayerData().getStands()) {
                if (this.getPlayerData().getPlayer() == player) {
                    Main.getEntityHider().showEntity(player, (Entity)armorStand);
                    continue;
                }
                Main.getEntityHider().hideEntity(player, (Entity)armorStand);
            }
        }
    }

    protected abstract ArmorStand spawnNameTag();

    protected abstract void move(LinkedHashMap<Location, Enums.ComponentType> var1);

    public PlayerData getPlayerData() {
        return this.playerData;
    }

    public LinkedHashMap<Location, Enums.ComponentType> getComponents() {
        return this.components;
    }

    public double getRemainingDistanceToTarget() {
        return this.remainingDistanceToTarget;
    }

    public double getTotalDistanceToTarget() {
        return this.totalDistanceToTarget;
    }

    public void setPlayerData(PlayerData playerData) {
        this.playerData = playerData;
    }

    public void setComponents(LinkedHashMap<Location, Enums.ComponentType> linkedHashMap) {
        this.components = linkedHashMap;
    }

    public void setRemainingDistanceToTarget(double d) {
        this.remainingDistanceToTarget = d;
    }

    public void setTotalDistanceToTarget(double d) {
        this.totalDistanceToTarget = d;
    }
}

