/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps.api;

import com.live.bemmamin.gps.api.events.GPSStartEvent;
import com.live.bemmamin.gps.api.events.GPSStopEvent;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.logic.Point;
import com.live.bemmamin.gps.playerdata.PlayerData;
import com.live.bemmamin.gps.utils.GPSUtil;
import com.live.bemmamin.gps.utils.StringUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Consumer;
import org.bukkit.util.Vector;

public class GPSAPI {
    private final Plugin plugin;

    public GPSAPI(Plugin plugin) {
        this.plugin = plugin;
    }

    public void addPoint(String string, Location location) {
        List list = GPSManager.getInstance().getExternalPoints().computeIfAbsent(this.plugin, plugin -> new ArrayList());
        if (!list.stream().noneMatch(point -> point.getName().equals(string))) {
            throw new IllegalArgumentException("A point with the name '" + string + "' already exists!");
        }
        location.setX((double)location.getBlockX() + 0.5);
        location.setY((double)location.getBlockY() + 0.1);
        location.setZ((double)location.getBlockZ() + 0.5);
        list.add(new Point(string, location));
    }

    public void removePoint(String string) {
        List list = GPSManager.getInstance().getExternalPoints().computeIfAbsent(this.plugin, plugin -> new ArrayList());
        list.stream().filter(point -> point.getName().equals(string)).findFirst().ifPresent(list::remove);
    }

    public void removeAllPoints() {
        GPSManager.getInstance().getExternalPoints().put(this.plugin, new ArrayList());
    }

    public void connect(String string, String string2, boolean bl) {
        Point point = null;
        Point point2 = null;
        for (Point point3 : GPSManager.getInstance().getGlobalPoints()) {
            if (point3.getName().equalsIgnoreCase(string)) {
                point = point3;
            }
            if (!point3.getName().equalsIgnoreCase(string2)) continue;
            point2 = point3;
        }
        if (point == null || point2 == null) {
            StringUtil.msgSend(null, "&7[&cGPS&7] &cCan't connect un-existing points.");
            return;
        }
        point.addConnection(point2);
        if (bl) {
            point2.addConnection(point);
        }
    }

    public void disconnect(String string, String string2, boolean bl) {
        Point point = null;
        Point point2 = null;
        for (Point point3 : GPSManager.getInstance().getGlobalPoints()) {
            if (point3.getName().equalsIgnoreCase(string)) {
                point = point3;
            }
            if (!point3.getName().equalsIgnoreCase(string2)) continue;
            point2 = point3;
        }
        if (point == null || point2 == null) {
            StringUtil.msgSend(null, "&7[&cGPS&7] &cCan't disconnect un-existing points.");
            return;
        }
        point.removeConnection(point2);
        if (bl) {
            point2.removeConnection(point);
        }
    }

    public void startGPS(Player player, String string, String string2) {
        this.startGPS(null, player, string, string2);
    }

    private void startGPS(String string, Player player, String string2, String string3) {
        Point point = null;
        Point point2 = null;
        for (Point point3 : Stream.concat(GPSManager.getInstance().getExternalPoints().getOrDefault(this.plugin, new ArrayList()).stream(), GPSManager.getInstance().getLocalPoints().stream()).collect(Collectors.toList())) {
            if (point3.getName().equalsIgnoreCase(string2)) {
                point = point3;
            }
            if (!point3.getName().equalsIgnoreCase(string3)) continue;
            point2 = point3;
        }
        GPSStartEvent gPSStartEvent = new GPSStartEvent(player, point2, GPSStartEvent.StartSource.OTHER_PLUGIN);
        Bukkit.getPluginManager().callEvent(gPSStartEvent);
        if (!gPSStartEvent.isCancelled()) {
            PlayerData.getPlayerData(player).startNavigation(point, point2, string);
        }
    }

    public void startGPS(Player player, String string) {
        this.startGPS(null, player, string);
    }

    private void startGPS(String string, Player player, String string2) {
        Point point = null;
        for (Point point2 : Stream.concat(GPSManager.getInstance().getExternalPoints().getOrDefault(this.plugin, new ArrayList()).stream(), GPSManager.getInstance().getLocalPoints().stream()).collect(Collectors.toList())) {
            if (!point2.getName().equalsIgnoreCase(string2)) continue;
            point = point2;
        }
        GPSStartEvent gPSStartEvent = new GPSStartEvent(player, point, GPSStartEvent.StartSource.OTHER_PLUGIN);
        Bukkit.getPluginManager().callEvent(gPSStartEvent);
        if (!gPSStartEvent.isCancelled()) {
            PlayerData.getPlayerData(player).startNavigation(point, false, string);
        }
    }

    public void stopGPS(Player player) {
        GPSStopEvent gPSStopEvent = new GPSStopEvent(player, GPSStopEvent.StopSource.OTHER_PLUGIN);
        Bukkit.getPluginManager().callEvent((Event)gPSStopEvent);
        if (!gPSStopEvent.isCancelled()) {
            PlayerData.getPlayerData(player).exitNavigation();
        }
    }

    public void startCompass(Player player, String string) {
        this.startCompass(null, player, string);
    }

    private void startCompass(String string, Player player, String string2) {
        Point point = null;
        for (Point point2 : Stream.concat(GPSManager.getInstance().getExternalPoints().getOrDefault(this.plugin, new ArrayList()).stream(), GPSManager.getInstance().getLocalPoints().stream()).collect(Collectors.toList())) {
            if (!point2.getName().equalsIgnoreCase(string2)) continue;
            point = point2;
        }
        GPSStartEvent gPSStartEvent = new GPSStartEvent(player, point, GPSStartEvent.StartSource.OTHER_PLUGIN, true);
        Bukkit.getPluginManager().callEvent(gPSStartEvent);
        if (!gPSStartEvent.isCancelled()) {
            PlayerData.getPlayerData(player).startNavigation(point, true, string);
        }
    }

    public void startCompass(Player player, Location location) {
        this.startCompass(null, player, location);
    }

    private void startCompass(String string, Player player, Location location) {
        location.setX((double)location.getBlockX() + 0.5);
        location.setY((double)location.getBlockY() + 0.1);
        location.setZ((double)location.getBlockZ() + 0.5);
        Point point = new Point("TempAPIPoint", location);
        GPSStartEvent gPSStartEvent = new GPSStartEvent(player, point, GPSStartEvent.StartSource.OTHER_PLUGIN, true);
        Bukkit.getPluginManager().callEvent((Event)gPSStartEvent);
        if (!gPSStartEvent.isCancelled()) {
            PlayerData.getPlayerData(player).startNavigation(point, true, string);
        }
    }

    public boolean gpsIsActive(Player player) {
        return PlayerData.getPlayerData(player).isGpsActive();
    }

    public String getDistanceToTarget(Player player) {
        PlayerData playerData = PlayerData.getPlayerData(player);
        return playerData.getAbstractArrow() == null ? "0.0" : StringUtil.formatDouble(playerData.getArrow().getRemainingDistanceToTarget());
    }

    public String getDistanceToTargetRounded(Player player) {
        PlayerData playerData = PlayerData.getPlayerData(player);
        return playerData.getAbstractArrow() == null ? "0" : StringUtil.formatDouble(playerData.getArrow().getRemainingDistanceToTarget()).substring(0, StringUtil.formatDouble(playerData.getArrow().getRemainingDistanceToTarget()).length() - 3);
    }

    public String getCardinalDirection(Player player) {
        float f = this.getCardinalDegrees(player);
        return f == -1.0f ? "None" : GPSUtil.yawToCardinalDirection(f);
    }

    public float getCardinalDegrees(Player player) {
        PlayerData playerData = PlayerData.getPlayerData(player);
        if (!playerData.isGpsActive() || playerData.getPath() == null) {
            return -1.0f;
        }
        Vector vector = playerData.getPath().getCurrentTarget().getLocation().clone().toVector();
        Location location = player.getLocation().clone();
        Vector vector2 = vector.subtract(player.getLocation().toVector());
        location.setDirection(vector2);
        float f = (location.getYaw() - 180.0f) % 360.0f;
        if (f < 0.0f) {
            f = (float)((double)f + 360.0);
        }
        return f;
    }

    public float getAngleToTarget(Player player) {
        PlayerData playerData = PlayerData.getPlayerData(player);
        if (!playerData.isGpsActive() || playerData.getPath() == null) {
            return -1.0f;
        }
        Vector vector = playerData.getPath().getCurrentTarget().getLocation().toVector();
        Vector vector2 = vector.clone().subtract(player.getLocation().toVector());
        Vector vector3 = player.getLocation().getDirection();
        boolean bl = vector.normalize().dot(vector2.clone().crossProduct(vector3)) <= 0.0;
        float f = (float)Math.toDegrees(vector2.angle(vector3));
        return bl ? f : -f;
    }

    public float getAngleToTarget2D(Player player) {
        PlayerData playerData = PlayerData.getPlayerData(player);
        if (!playerData.isGpsActive() || playerData.getPath() == null) {
            return -1.0f;
        }
        Location location = player.getLocation();
        Location location2 = playerData.getPath().getCurrentTarget().getLocation().clone();
        location.setY(0.0);
        location.setPitch(0.0f);
        location2.setY(0.0);
        location2.setPitch(0.0f);
        Vector vector = location2.toVector().subtract(location.toVector());
        Vector vector2 = location.getDirection();
        boolean bl = vector2.clone().normalize().dot(vector.clone().crossProduct(new Vector(0, 1, 0))) <= 0.0;
        float f = (float)Math.toDegrees(vector.angle(vector2));
        return bl ? -f : f;
    }

    public List<Point> getConfigurationPoints() {
        return GPSManager.getInstance().getLocalPoints();
    }

    public List<Point> getAllPoints() {
        return GPSManager.getInstance().getGlobalPoints();
    }

    public List<Point> getPluginPoints(String string) {
        Plugin plugin2 = GPSManager.getInstance().getExternalPoints().keySet().stream().filter(plugin -> plugin.getName().equals(string)).findFirst().orElse(null);
        return GPSManager.getInstance().getExternalPoints().get(plugin2);
    }

    public void getClosestConfigurationPoint(Location location, Consumer<Point> consumer) {
        this.resolveClosestPoint(location, consumer, GPSManager.getInstance().getLocalPoints());
    }

    public void getClosestConfigurationPoint(Player player, Consumer<Point> consumer) {
        this.resolveClosestPoint(player.getLocation().clone(), consumer, GPSManager.getInstance().getLocalPoints());
    }

    public void getClosestGlobalPoint(Location location, Consumer<Point> consumer) {
        this.resolveClosestPoint(location, consumer, GPSManager.getInstance().getGlobalPoints());
    }

    public void getClosestGlobalPoint(Player player, Consumer<Point> consumer) {
        this.resolveClosestPoint(player.getLocation().clone(), consumer, GPSManager.getInstance().getGlobalPoints());
    }

    private void resolveClosestPoint(Location location, Consumer<Point> consumer, List<Point> list) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            Point point2 = list.stream().filter(point -> point.getLocation().getWorld().getName().equals(location.getWorld().getName())).min(Comparator.comparingDouble(point -> point.getLocation().distance(location))).orElse(null);
            Bukkit.getScheduler().runTask(this.plugin, () -> consumer.accept((Object)point2));
        });
    }
}

