/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.utils.ParticleUtil;
import com.live.bemmamin.gps.utils.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;

public final class Vars {
    private static Vars vars;
    private final Main main;
    private final Map<Integer, ArmorStand> standMap = new HashMap<Integer, ArmorStand>();
    private boolean disableGPSUsage;
    private Material material;
    private byte data;
    private double arrowDensity;
    private double arrowLength;
    private double headLength;
    private double headOffset;
    private String arrowName;
    private boolean useActionbar;
    private double defaultHorizontalOffset;
    private double defaultVerticalOffset;
    private double minHorizontalOffset;
    private double maxHorizontalOffset;
    private double minVerticalOffset;
    private double maxVerticalOffset;
    private double particleDensity = 1.0;
    private double particleRenderDistance;
    private long particleUpdateRate;
    private Float[] lineColor;
    private Float[] connectedColor;
    private Float[] defaultPointColor;
    private Float[] selectedPointColor;
    private Float[] closestPointColor;
    private Float[] particleArrowColor;
    private double maxDistanceToEntry;
    private double pointUpdateDistance;
    private double selectionMaxDistance;
    private long gpsUpdateInterval = 3L;
    private boolean showForOwnerOnly;
    private boolean disableArrow;
    private boolean autoShow;
    private double playerPathOffset;
    private boolean particleArrow;
    private boolean particleArrow3D;
    private boolean resourcePackArrow;
    private Material resourcePackArrowMaterial;
    private short resourcePackArrowDurability;
    private int resourcePackCustomModelData;
    private boolean bossBarEnabled;
    private BarColor bossBarColor;
    private BarStyle bossBarStyle;
    private String bossBarMessage;
    private boolean bossBarCompassEnabled;
    private String bossBarCompassNorth;
    private String bossBarCompassEast;
    private String bossBarCompassSouth;
    private String bossBarCompassWest;
    private String bossBarCompassTarget;
    private String bossBarCompassTargetAbove;
    private String bossBarCompassTargetBelow;
    private int bossBarCompassTargetOffset;
    private String bossBarCompassSeparator;
    private int bossBarCompassSeparatorLength;
    private int bossBarCompassTotalLength;
    private String bossBarCompassPrefix;
    private String bossBarCompassSuffix;
    private boolean updateCheckerEnabled;
    private boolean updateCheckerPermissionOnly;
    private boolean saveOnQuit;
    private long maxQuitTime;
    private boolean inactivityTimerEnabled;
    private long maxInactivity;
    private boolean disableHungerWhenActive;
    private boolean fixedArrowHeight;
    private boolean startOnDeath;
    private boolean startOnDeathWorldReentry;
    private boolean continueOnRespawn;
    private double teleportConnectionDistance;
    private boolean compassItemEnabled;
    private boolean giveCompass;
    private String compassItemName;
    private List<String> compassItemLore;
    private boolean germanLocale;

    private Vars() {
        this.main = (Main)Main.getPlugin(Main.class);
        this.loadVariables();
    }

    public static Vars getInstance() {
        vars = vars == null ? new Vars() : vars;
        return vars;
    }

    public void loadVariables() {
        this.main.reloadConfig();
        this.main.saveDefaultConfig();
        FileConfiguration fileConfiguration = this.main.getConfig();
        String[] stringArray = fileConfiguration.getString("block", "Quartz_Block").replace(" ", "").split(":");
        this.material = Material.matchMaterial((String)stringArray[0]) != null ? Material.matchMaterial((String)stringArray[0]) : Material.QUARTZ_BLOCK;
        this.data = stringArray.length == 2 ? Byte.parseByte(stringArray[1]) : (byte)0;
        this.arrowDensity = fileConfiguration.getDouble("arrowDensity", 0.3);
        this.arrowLength = fileConfiguration.getDouble("arrowLength", 2.1);
        this.headLength = fileConfiguration.getDouble("headLength", 0.9);
        this.headOffset = fileConfiguration.getDouble("headOffset", 0.3);
        this.arrowName = fileConfiguration.getString("arrowName", "&a%distance% blocks to destination");
        this.useActionbar = fileConfiguration.getBoolean("useActionbar", false);
        this.defaultHorizontalOffset = fileConfiguration.getDouble("defaultHorizontalOffset", 6.0);
        this.defaultVerticalOffset = fileConfiguration.getDouble("defaultVerticalOffset", 2.5);
        this.minHorizontalOffset = fileConfiguration.getDouble("minHorizontalOffset", 3.0);
        this.maxHorizontalOffset = fileConfiguration.getDouble("maxHorizontalOffset", 10.0);
        this.minVerticalOffset = fileConfiguration.getDouble("minVerticalOffset", -2.0);
        this.maxVerticalOffset = fileConfiguration.getDouble("maxVerticalOffset", 6.0);
        this.fixedArrowHeight = fileConfiguration.getBoolean("fixedArrowHeight", false);
        this.particleDensity = fileConfiguration.getDouble("particleDensity", 1.0);
        this.particleRenderDistance = fileConfiguration.getDouble("particleRenderDistance", 25.0);
        this.particleUpdateRate = fileConfiguration.getLong("particleUpdateRate", 5L);
        this.lineColor = ParticleUtil.parseColor(fileConfiguration.getString("lineColor", "1,1,255"));
        this.connectedColor = ParticleUtil.parseColor(fileConfiguration.getString("connectedColor", "1,255,255"));
        this.defaultPointColor = ParticleUtil.parseColor(fileConfiguration.getString("defaultPointColor", "255,1,1"));
        this.selectedPointColor = ParticleUtil.parseColor(fileConfiguration.getString("selectedPointColor", "1,255,1"));
        this.closestPointColor = ParticleUtil.parseColor(fileConfiguration.getString("closestPointColor", "255,255,1"));
        this.maxDistanceToEntry = fileConfiguration.getDouble("maxDistanceToEntry", 50.0);
        this.pointUpdateDistance = fileConfiguration.getDouble("pointUpdateDistance", 5.0);
        this.selectionMaxDistance = fileConfiguration.getDouble("selectionDistance", 10.0);
        this.gpsUpdateInterval = fileConfiguration.getLong("gpsUpdateInterval", 3L);
        this.showForOwnerOnly = fileConfiguration.getBoolean("showForOwnerOnly", true);
        this.disableArrow = fileConfiguration.getBoolean("disableArrow", false);
        this.autoShow = fileConfiguration.getBoolean("autoShowPath", false);
        this.playerPathOffset = fileConfiguration.getDouble("playerPathOffset", 0.0);
        this.particleArrow = fileConfiguration.getBoolean("particleArrow", false);
        this.particleArrow3D = fileConfiguration.getBoolean("particleArrow3D", false);
        this.particleArrowColor = ParticleUtil.parseColor(fileConfiguration.getString("particleArrowColor", "255,1,1"));
        this.resourcePackArrow = fileConfiguration.getBoolean("resourcePackArrow", false);
        this.resourcePackArrowMaterial = Material.matchMaterial((String)fileConfiguration.getString("resourcePackArrowMaterial", "IRON_HOE"));
        this.resourcePackArrowDurability = (short)fileConfiguration.getInt("resourcePackArrowDurability", 1);
        this.resourcePackCustomModelData = fileConfiguration.getInt("resourcePackCustomModelData", 0);
        boolean bl = this.bossBarEnabled = fileConfiguration.getBoolean("bossBarEnabled", true) && !Bukkit.getVersion().contains("1.8");
        if (!Bukkit.getVersion().contains("1.8")) {
            this.bossBarColor = BarColor.valueOf((String)fileConfiguration.getString("bossBarColor", "RED"));
            this.bossBarStyle = BarStyle.valueOf((String)fileConfiguration.getString("bossBarStyle", "SOLID"));
            this.bossBarMessage = fileConfiguration.getString("bossBarMessage", "&f%remainingRounded% blocks left of %totalRounded%");
            this.bossBarCompassEnabled = fileConfiguration.getBoolean("BossBarCompass.enabled", false);
            this.bossBarCompassNorth = fileConfiguration.getString("BossBarCompass.north", "&a&lN");
            this.bossBarCompassEast = fileConfiguration.getString("BossBarCompass.east", "&a&lE");
            this.bossBarCompassSouth = fileConfiguration.getString("BossBarCompass.south", "&a&lS");
            this.bossBarCompassWest = fileConfiguration.getString("BossBarCompass.west", "&a&lW");
            this.bossBarCompassTarget = fileConfiguration.getString("BossBarCompass.target", "&c&l\u2b24");
            this.bossBarCompassTargetAbove = fileConfiguration.getString("BossBarCompass.targetAbove", "&c&l\u2b06");
            this.bossBarCompassTargetBelow = fileConfiguration.getString("BossBarCompass.targetBelow", "&c&l\u2b07");
            this.bossBarCompassTargetOffset = fileConfiguration.getInt("BossBarCompass.targetOffset", 2);
            this.bossBarCompassSeparator = fileConfiguration.getString("BossBarCompass.separator", "&f&m ");
            this.bossBarCompassSeparatorLength = fileConfiguration.getInt("BossBarCompass.separatorLength", 15);
            this.bossBarCompassTotalLength = fileConfiguration.getInt("BossBarCompass.totalLength", 40);
            this.bossBarCompassPrefix = fileConfiguration.getString("BossBarCompass.prefix", "");
            this.bossBarCompassSuffix = fileConfiguration.getString("BossBarCompass.suffix", "");
        }
        this.updateCheckerEnabled = fileConfiguration.getBoolean("updateCheckerEnabled", true);
        this.updateCheckerPermissionOnly = fileConfiguration.getBoolean("updateCheckerPermissionOnly", false);
        this.saveOnQuit = fileConfiguration.getBoolean("saveOnQuit", true);
        this.maxQuitTime = fileConfiguration.getLong("maxQuitTime", 3600L);
        this.inactivityTimerEnabled = fileConfiguration.getBoolean("InactivityTimer.enabled", true);
        this.maxInactivity = fileConfiguration.getLong("InactivityTimer.maxInactivitySeconds", 300L);
        this.disableHungerWhenActive = fileConfiguration.getBoolean("disableHungerWhenActive", false);
        this.startOnDeath = fileConfiguration.getBoolean("startOnRespawn", false);
        this.startOnDeathWorldReentry = fileConfiguration.getBoolean("startOnDeathWorldReentry", false);
        this.continueOnRespawn = fileConfiguration.getBoolean("continueOnRespawn", false);
        this.teleportConnectionDistance = fileConfiguration.getDouble("teleportConnectionDistance", 0.0);
        this.compassItemEnabled = fileConfiguration.getBoolean("CompassItem.enabled", false);
        this.giveCompass = fileConfiguration.getBoolean("CompassItem.giveCompass", true);
        this.compassItemName = StringUtil.translate(fileConfiguration.getString("CompassItem.name", "&eGPS Compass"));
        this.compassItemLore = (fileConfiguration.contains("CompassItem.lore") ? fileConfiguration.getStringList("CompassItem.lore") : Arrays.asList("", "&7Points towards the next location.")).stream().map(StringUtil::translate).collect(Collectors.toList());
        this.germanLocale = fileConfiguration.getString("decimalFormat", "GERMAN").equalsIgnoreCase("GERMAN");
    }

    public void toggleGPSUsage() {
        this.disableGPSUsage = !this.disableGPSUsage;
    }

    public Map<Integer, ArmorStand> getStandMap() {
        return this.standMap;
    }

    public boolean isDisableGPSUsage() {
        return this.disableGPSUsage;
    }

    public Material getMaterial() {
        return this.material;
    }

    public byte getData() {
        return this.data;
    }

    public double getArrowDensity() {
        return this.arrowDensity;
    }

    public double getArrowLength() {
        return this.arrowLength;
    }

    public double getHeadLength() {
        return this.headLength;
    }

    public double getHeadOffset() {
        return this.headOffset;
    }

    public String getArrowName() {
        return this.arrowName;
    }

    public boolean isUseActionbar() {
        return this.useActionbar;
    }

    public double getDefaultHorizontalOffset() {
        return this.defaultHorizontalOffset;
    }

    public double getDefaultVerticalOffset() {
        return this.defaultVerticalOffset;
    }

    public double getMinHorizontalOffset() {
        return this.minHorizontalOffset;
    }

    public double getMaxHorizontalOffset() {
        return this.maxHorizontalOffset;
    }

    public double getMinVerticalOffset() {
        return this.minVerticalOffset;
    }

    public double getMaxVerticalOffset() {
        return this.maxVerticalOffset;
    }

    public double getParticleDensity() {
        return this.particleDensity;
    }

    public double getParticleRenderDistance() {
        return this.particleRenderDistance;
    }

    public long getParticleUpdateRate() {
        return this.particleUpdateRate;
    }

    public Float[] getLineColor() {
        return this.lineColor;
    }

    public Float[] getConnectedColor() {
        return this.connectedColor;
    }

    public Float[] getDefaultPointColor() {
        return this.defaultPointColor;
    }

    public Float[] getSelectedPointColor() {
        return this.selectedPointColor;
    }

    public Float[] getClosestPointColor() {
        return this.closestPointColor;
    }

    public Float[] getParticleArrowColor() {
        return this.particleArrowColor;
    }

    public double getMaxDistanceToEntry() {
        return this.maxDistanceToEntry;
    }

    public double getPointUpdateDistance() {
        return this.pointUpdateDistance;
    }

    public double getSelectionMaxDistance() {
        return this.selectionMaxDistance;
    }

    public long getGpsUpdateInterval() {
        return this.gpsUpdateInterval;
    }

    public boolean isShowForOwnerOnly() {
        return this.showForOwnerOnly;
    }

    public boolean isDisableArrow() {
        return this.disableArrow;
    }

    public boolean isAutoShow() {
        return this.autoShow;
    }

    public double getPlayerPathOffset() {
        return this.playerPathOffset;
    }

    public boolean isParticleArrow() {
        return this.particleArrow;
    }

    public boolean isParticleArrow3D() {
        return this.particleArrow3D;
    }

    public boolean isResourcePackArrow() {
        return this.resourcePackArrow;
    }

    public Material getResourcePackArrowMaterial() {
        return this.resourcePackArrowMaterial;
    }

    public short getResourcePackArrowDurability() {
        return this.resourcePackArrowDurability;
    }

    public int getResourcePackCustomModelData() {
        return this.resourcePackCustomModelData;
    }

    public boolean isBossBarEnabled() {
        return this.bossBarEnabled;
    }

    public BarColor getBossBarColor() {
        return this.bossBarColor;
    }

    public BarStyle getBossBarStyle() {
        return this.bossBarStyle;
    }

    public String getBossBarMessage() {
        return this.bossBarMessage;
    }

    public boolean isBossBarCompassEnabled() {
        return this.bossBarCompassEnabled;
    }

    public String getBossBarCompassNorth() {
        return this.bossBarCompassNorth;
    }

    public String getBossBarCompassEast() {
        return this.bossBarCompassEast;
    }

    public String getBossBarCompassSouth() {
        return this.bossBarCompassSouth;
    }

    public String getBossBarCompassWest() {
        return this.bossBarCompassWest;
    }

    public String getBossBarCompassTarget() {
        return this.bossBarCompassTarget;
    }

    public String getBossBarCompassTargetAbove() {
        return this.bossBarCompassTargetAbove;
    }

    public String getBossBarCompassTargetBelow() {
        return this.bossBarCompassTargetBelow;
    }

    public int getBossBarCompassTargetOffset() {
        return this.bossBarCompassTargetOffset;
    }

    public String getBossBarCompassSeparator() {
        return this.bossBarCompassSeparator;
    }

    public int getBossBarCompassSeparatorLength() {
        return this.bossBarCompassSeparatorLength;
    }

    public int getBossBarCompassTotalLength() {
        return this.bossBarCompassTotalLength;
    }

    public String getBossBarCompassPrefix() {
        return this.bossBarCompassPrefix;
    }

    public String getBossBarCompassSuffix() {
        return this.bossBarCompassSuffix;
    }

    public boolean isUpdateCheckerEnabled() {
        return this.updateCheckerEnabled;
    }

    public boolean isUpdateCheckerPermissionOnly() {
        return this.updateCheckerPermissionOnly;
    }

    public boolean isSaveOnQuit() {
        return this.saveOnQuit;
    }

    public long getMaxQuitTime() {
        return this.maxQuitTime;
    }

    public boolean isInactivityTimerEnabled() {
        return this.inactivityTimerEnabled;
    }

    public long getMaxInactivity() {
        return this.maxInactivity;
    }

    public boolean isDisableHungerWhenActive() {
        return this.disableHungerWhenActive;
    }

    public boolean isFixedArrowHeight() {
        return this.fixedArrowHeight;
    }

    public boolean isStartOnDeath() {
        return this.startOnDeath;
    }

    public boolean isStartOnDeathWorldReentry() {
        return this.startOnDeathWorldReentry;
    }

    public boolean isContinueOnRespawn() {
        return this.continueOnRespawn;
    }

    public double getTeleportConnectionDistance() {
        return this.teleportConnectionDistance;
    }

    public boolean isCompassItemEnabled() {
        return this.compassItemEnabled;
    }

    public boolean isGiveCompass() {
        return this.giveCompass;
    }

    public String getCompassItemName() {
        return this.compassItemName;
    }

    public List<String> getCompassItemLore() {
        return this.compassItemLore;
    }

    public boolean isGermanLocale() {
        return this.germanLocale;
    }

    public void setMaxDistanceToEntry(double d) {
        this.maxDistanceToEntry = d;
    }
}

