/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.PluginPermission;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.utils.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateChecker
implements Listener {
    private static final int ID = 53672;
    private static final Permission UPDATE_PERM = new Permission(PluginPermission.UPDATE.getPermission(), PermissionDefault.FALSE);
    private final JavaPlugin javaPlugin;
    private final String localPluginVersion;
    private String spigotPluginVersion;

    UpdateChecker(Main main) {
        this.javaPlugin = main;
        this.localPluginVersion = main.getDescription().getVersion();
    }

    void checkForUpdate() {
        new BukkitRunnable(){

            public void run() {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)UpdateChecker.this.javaPlugin, () -> {
                    if (!Vars.getInstance().isUpdateCheckerEnabled()) {
                        return;
                    }
                    try {
                        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=%%__RESOURCE__%%").openConnection();
                        httpsURLConnection.setRequestMethod("GET");
                        UpdateChecker.this.spigotPluginVersion = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream())).readLine();
                    }
                    catch (IOException iOException) {
                        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cUpdate checker failed! Disabling."));
                        iOException.printStackTrace();
                        this.cancel();
                        return;
                    }
                    if (UpdateChecker.this.isLatestVersion()) {
                        return;
                    }
                    StringUtil.msgSend(null, "&7[&eGPS&7] &fA new update is available at:");
                    StringUtil.msgSend(null, "&bhttps://www.spigotmc.org/resources/%%__RESOURCE__%%/updates");
                    Bukkit.getScheduler().runTask((Plugin)UpdateChecker.this.javaPlugin, () -> Bukkit.getPluginManager().registerEvents(new Listener(){

                        @EventHandler(priority=EventPriority.MONITOR)
                        public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
                            Player player = playerJoinEvent.getPlayer();
                            if (player.hasPermission(UPDATE_PERM) || player.isOp() && !Vars.getInstance().isUpdateCheckerPermissionOnly()) {
                                StringUtil.msgSend(playerJoinEvent.getPlayer(), "&7[&eGPS&7] &fA new update is available at:");
                                StringUtil.msgSend(playerJoinEvent.getPlayer(), "&bhttps://www.spigotmc.org/resources/%%__RESOURCE__%%/updates");
                            }
                        }
                    }, (Plugin)UpdateChecker.this.javaPlugin));
                    this.cancel();
                });
            }
        }.runTaskTimer((Plugin)this.javaPlugin, 0L, 12000L);
    }

    private boolean isLatestVersion() {
        try {
            int[] nArray = Arrays.stream(this.localPluginVersion.split("\\.")).mapToInt(Integer::parseInt).toArray();
            int[] nArray2 = Arrays.stream(this.spigotPluginVersion.split("\\.")).mapToInt(Integer::parseInt).toArray();
            return IntStream.range(0, nArray.length).filter(n -> nArray[n] != nArray2[n]).limit(1L).mapToObj(n -> nArray[n] >= nArray2[n]).findFirst().orElse(true);
        }
        catch (NumberFormatException numberFormatException) {
            return this.localPluginVersion.equals(this.spigotPluginVersion);
        }
    }

    public String getLocalPluginVersion() {
        return this.localPluginVersion;
    }

    public String getSpigotPluginVersion() {
        return this.spigotPluginVersion;
    }
}

