/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps;

import com.live.bemmamin.gps.InactivityTimer;
import com.live.bemmamin.gps.MetricsLite;
import com.live.bemmamin.gps.UpdateChecker;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.commands.CommandManager;
import com.live.bemmamin.gps.commands.admin.AdminCommand;
import com.live.bemmamin.gps.commands.compass.CompassCommand;
import com.live.bemmamin.gps.commands.configurator.ConfiguratorCommand;
import com.live.bemmamin.gps.commands.gps.GPSCommand;
import com.live.bemmamin.gps.dynmap.DynmapHook;
import com.live.bemmamin.gps.events.CompassItemListener;
import com.live.bemmamin.gps.events.ConfiguratorUseListener;
import com.live.bemmamin.gps.events.DeathTargetListeners;
import com.live.bemmamin.gps.events.EnderPearlListener;
import com.live.bemmamin.gps.events.EntityDeathEvent;
import com.live.bemmamin.gps.events.EventRegistry;
import com.live.bemmamin.gps.events.FoodLevelChangeListener;
import com.live.bemmamin.gps.events.PlayerJoinListener;
import com.live.bemmamin.gps.events.PlayerMoveListener;
import com.live.bemmamin.gps.events.PlayerQuitListener;
import com.live.bemmamin.gps.events.PlayerSlotChangeListener;
import com.live.bemmamin.gps.events.PlayerTeleportListener;
import com.live.bemmamin.gps.events.ProjectileHitListener;
import com.live.bemmamin.gps.events.WorldChangeListener;
import com.live.bemmamin.gps.files.CrashSafetyFile;
import com.live.bemmamin.gps.files.DynmapFile;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.logic.GPSManager;
import com.live.bemmamin.gps.playerdata.PlayerData;
import com.live.bemmamin.gps.utils.EntityHider;
import com.live.bemmamin.gps.utils.GPSUtil;
import com.live.bemmamin.gps.utils.ParticleUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private static EntityHider entityHider;
    private static DynmapHook dynmap;
    private static boolean placeHolderAPIEnabled;
    private InactivityTimer inactivityTimer;
    private UpdateChecker updateChecker;

    public static void setDynmap(DynmapHook dynmapHook) {
        dynmap = dynmapHook;
    }

    public void onEnable() {
        new MetricsLite((Plugin)this, 2294);
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        Vars.getInstance();
        EventRegistry.registerEvents(this, new ConfiguratorUseListener(), new DeathTargetListeners(this), new EntityDeathEvent(this), new FoodLevelChangeListener(), new PlayerJoinListener(this), new PlayerMoveListener(this), new PlayerQuitListener(), new PlayerSlotChangeListener(), new PlayerTeleportListener(this), new WorldChangeListener(this), new EnderPearlListener(this), new CompassItemListener(), new ProjectileHitListener());
        CommandManager.registerCommands(this, new GPSCommand(this), new CompassCommand(this), new ConfiguratorCommand(this), new AdminCommand(this));
        MessagesFile.getInstance();
        DynmapFile.getInstance();
        entityHider = this.getServer().getPluginManager().getPlugin("ProtocolLib") != null && Vars.getInstance().isShowForOwnerOnly() && Main.getEntityHider() == null && !Vars.getInstance().isDisableArrow() ? new EntityHider((Plugin)this, EntityHider.Policy.BLACKLIST) : null;
        placeHolderAPIEnabled = this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI");
        this.updateChecker = new UpdateChecker(this);
        this.updateChecker.checkForUpdate();
        this.inactivityTimer = new InactivityTimer(this);
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            CrashSafetyFile.getInstance().crashCheckEntities();
            GPSManager.getInstance().loadConfigurationPoints();
            GPSUtil.cleanUp();
            if (Bukkit.getServer().getPluginManager().getPlugin("dynmap") != null && DynmapFile.getInstance().getConfig().getBoolean("enabled")) {
                dynmap = new DynmapHook();
                Main.getDynmap().updateDynmapGPS();
            }
        }, 1L);
        ParticleUtil.startRainbowTask(this);
    }

    public void onDisable() {
        Vars.getInstance().getStandMap().values().stream().filter(Objects::nonNull).forEach(Entity::remove);
        PlayerData.getPlayerData().values().forEach(playerData -> {
            playerData.getBossBarTracker().remove();
            playerData.exitNavigation();
        });
    }

    public static EntityHider getEntityHider() {
        return entityHider;
    }

    public static DynmapHook getDynmap() {
        return dynmap;
    }

    public static boolean isPlaceHolderAPIEnabled() {
        return placeHolderAPIEnabled;
    }

    public InactivityTimer getInactivityTimer() {
        return this.inactivityTimer;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=%%__USER__%%&resource_id=%%__RESOURCE__%%&nonce=%%__NONCE__%%").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

