/*
 * Decompiled with CFR 0.152.
 */
package com.live.bemmamin.gps;

import com.live.bemmamin.gps.Main;
import com.live.bemmamin.gps.Vars;
import com.live.bemmamin.gps.files.MessagesFile;
import com.live.bemmamin.gps.playerdata.PlayerData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class InactivityTimer {
    private final Main main;
    private final Map<UUID, Long> timedPlayers = new HashMap<UUID, Long>();

    InactivityTimer(Main main) {
        this.main = main;
        this.startTimerTask();
    }

    public void updatePlayer(UUID uUID) {
        this.timedPlayers.put(uUID, System.currentTimeMillis());
    }

    public void removePlayer(UUID uUID) {
        this.timedPlayers.remove(uUID);
    }

    private void startTimerTask() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.main, () -> this.timedPlayers.entrySet().stream().filter(entry -> {
            if (!Vars.getInstance().isInactivityTimerEnabled() || this.timedPlayers.isEmpty()) {
                return false;
            }
            long l = (System.currentTimeMillis() - (Long)entry.getValue()) / 1000L;
            if (l < Vars.getInstance().getMaxInactivity()) {
                return false;
            }
            Player player = Bukkit.getPlayer((UUID)((UUID)entry.getKey()));
            if (player != null && PlayerData.contains(player) && PlayerData.getPlayerData(player).isGpsActive()) {
                MessagesFile.getInstance().getMaxInactivity().send(player);
            }
            return true;
        }).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(uUID -> {
            if (Bukkit.getPlayer((UUID)uUID) != null) {
                PlayerData.getPlayerData(Bukkit.getPlayer((UUID)uUID)).exitNavigation();
            }
            this.timedPlayers.remove(uUID);
        }), 0L, 20L);
    }
}

