/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.sdutils.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import me.chancesd.pvpmanager.sdutils.database.DatabaseConfigBuilder;
import me.chancesd.pvpmanager.sdutils.database.DatabaseFactory;
import me.chancesd.pvpmanager.sdutils.database.Table;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import me.chancesd.pvpmanager.sdutils.utils.MCVersion;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class Database {
    private static final String MYSQL_URL_TEMPLATE = "jdbc:mysql://%s/%s";
    private static final String SQLITE_URL_TEMPLATE = "jdbc:sqlite:%s";
    private final JavaPlugin plugin;
    private final DatabaseConfigBuilder.DatabaseType databaseType;
    private final Map<String, Table> tableRegister = new HashMap<String, Table>();
    private boolean converted;
    private final HikariDataSource connectionPool;
    private static final String SQL_SELECT_ALL = "SELECT * FROM ";
    private static final String SQL_INSERT_INTO = "INSERT INTO ";
    private static final String SQL_WHERE = " WHERE ";
    private static final String SQL_VALUES = " VALUES(";

    protected Database(DatabaseFactory databaseFactory, DatabaseConfigBuilder builder) {
        this.plugin = databaseFactory.getPlugin();
        this.databaseType = builder.getType();
        HikariConfig config = new HikariConfig();
        if (this.databaseType == DatabaseConfigBuilder.DatabaseType.SQLITE) {
            if (MCVersion.isLowerThan(MCVersion.V1_9)) {
                try {
                    Class.forName("org.sqlite.JDBC");
                    config.setConnectionTestQuery("SELECT 1;");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            config.setJdbcUrl(String.format(SQLITE_URL_TEMPLATE, builder.getFile()));
            if (MCVersion.isAtLeast(MCVersion.V1_9)) {
                config.addDataSourceProperty("journal_mode", (Object)"wal");
            }
            config.addDataSourceProperty("synchronous", (Object)"normal");
        } else {
            config.setJdbcUrl(String.format(MYSQL_URL_TEMPLATE, builder.getUrl(), builder.getDatabase()));
            config.setUsername(builder.getUser());
            config.setPassword(builder.getPassword());
        }
        config.setPoolName(this.plugin.getName());
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        this.setLogLevel(Level.WARN);
        this.connectionPool = new HikariDataSource(config);
        this.setLogLevel(Level.INFO);
        if (!this.converted) {
            databaseFactory.doConversion(this);
            this.converted = true;
        }
    }

    public <T> void doQuery(String sql, Consumer<T> consumer, String field, Class<T> type) {
        CompletableFuture.runAsync(() -> {
            try (Connection connection = this.getConnection();
                 PreparedStatement ps = connection.prepareStatement(sql);
                 ResultSet result = ps.executeQuery();){
                if (result.next()) {
                    Object value = result.getObject(field, type);
                    consumer.accept(value);
                }
            }
            catch (SQLException e) {
                this.log("Failed to do query", e);
            }
        });
    }

    public void registerTable(Table table) {
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + table.getName() + table.getUsage());){
            ps.executeUpdate();
            this.tableRegister.put(table.getName(), table);
        }
        catch (SQLException e) {
            this.log("Failed to register table", e);
        }
    }

    public void deleteTable(String table) {
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement("DROP TABLE " + table);){
            ps.executeUpdate();
            this.tableRegister.remove(table);
        }
        catch (SQLException e) {
            this.log("Failed to delete table", e);
        }
    }

    public void renameTable(String oldName, String newName) {
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement("RENAME " + oldName + " TO " + newName);){
            ps.executeUpdate();
            Table table = this.tableRegister.get(oldName);
            if (table != null) {
                this.tableRegister.remove(oldName);
                this.tableRegister.put(newName, table);
            }
        }
        catch (SQLException e) {
            this.log("Failed to rename table", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean tableExists(String table) {
        try (Connection connection = this.getConnection();){
            boolean bl;
            block14: {
                DatabaseMetaData metadata = connection.getMetaData();
                ResultSet result = metadata.getTables(null, null, table, null);
                try {
                    bl = result.next();
                    if (result == null) break block14;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.log("Failed to check if table exists", e);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean columnExists(String table, String column) {
        try (Connection connection = this.getConnection();){
            boolean bl;
            block14: {
                DatabaseMetaData metadata = connection.getMetaData();
                ResultSet result = metadata.getColumns(null, null, table, column);
                try {
                    bl = result.next();
                    if (result == null) break block14;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.log("Failed to check database if column exists", e);
            return false;
        }
    }

    public void insertDefault(Table table, Object ... values) {
        try (Connection connection = this.getConnection();){
            StringBuilder valueCount = this.getValueParameteres(Arrays.asList(values));
            try (PreparedStatement ps = connection.prepareStatement(SQL_INSERT_INTO + table.getName() + SQL_VALUES + String.valueOf(valueCount) + ");");){
                for (int i = 0; i < values.length; ++i) {
                    ps.setObject(i + 1, values[i]);
                }
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.log("Failed to insert data to database", e);
        }
    }

    public boolean insertColumns(Table table, Collection<String> columns, Collection<Object> values) {
        boolean bl;
        block17: {
            Connection connection = this.getConnection();
            try {
                StringBuilder valueCount = this.getValueParameteres(values);
                StringBuilder columnList = new StringBuilder("(");
                int index = 0;
                for (String col : columns) {
                    columnList.append(col);
                    if (++index >= columns.size()) continue;
                    columnList.append(",");
                }
                columnList.append(")");
                try (PreparedStatement ps = connection.prepareStatement(SQL_INSERT_INTO + table.getName() + String.valueOf(columnList) + SQL_VALUES + String.valueOf(valueCount) + ");");){
                    int i = 0;
                    for (Object object : values) {
                        ps.setObject(++i, object);
                    }
                    ps.executeUpdate();
                }
                bl = true;
                if (connection == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.log("Failed to insert data to database", e);
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    public void insertColumnsBatch(Table table, Collection<String> columns, Collection<Collection<Object>> values) {
        try (Connection connection = this.getConnection();){
            Collection collection = values.stream().findFirst().orElse(Collections.emptyList());
            StringBuilder valueCount = this.getValueParameteres(collection);
            StringBuilder columnList = new StringBuilder("(");
            int index = 0;
            for (String col : columns) {
                columnList.append(col);
                if (++index >= columns.size()) continue;
                columnList.append(",");
            }
            columnList.append(")");
            try (PreparedStatement ps = connection.prepareStatement(SQL_INSERT_INTO + table.getName() + String.valueOf(columnList) + SQL_VALUES + String.valueOf(valueCount) + ");");){
                int inserts = 0;
                for (Collection<Object> object : values) {
                    int i = 0;
                    for (Object value : object) {
                        ps.setObject(++i, value);
                    }
                    ps.addBatch();
                    if (++inserts % 1000 != 0 && inserts != values.size()) continue;
                    ps.executeBatch();
                }
            }
        }
        catch (SQLException e) {
            this.log("Failed to insert batch data to database", e);
        }
    }

    public void updateValuesBatch(Table table, String index, Collection<String> columns, Map<Object, Collection<Object>> indexToValues) {
        try (Connection connection = this.getConnection();){
            StringBuilder updateString = new StringBuilder();
            int i = 0;
            for (String col : columns) {
                updateString.append(col + "=?");
                if (++i >= columns.size()) continue;
                updateString.append(",");
            }
            try (PreparedStatement ps = connection.prepareStatement("UPDATE " + table.getName() + " SET " + String.valueOf(updateString) + SQL_WHERE + index + "=?");){
                int updates = 0;
                for (Map.Entry<Object, Collection<Object>> entry : indexToValues.entrySet()) {
                    int paramIndex = 1;
                    for (Object value : entry.getValue()) {
                        ps.setObject(paramIndex++, value);
                    }
                    ps.setObject(paramIndex, entry.getKey());
                    ps.addBatch();
                    if (++updates % 1000 != 0 && updates != indexToValues.size()) continue;
                    ps.executeBatch();
                }
            }
        }
        catch (SQLException e) {
            this.log("Failed to batch update database", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getValue(Table table, String index, String column, Object value) {
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(SQL_SELECT_ALL + table.getName() + SQL_WHERE + index + "=?");){
            ps.setObject(1, value);
            try (ResultSet result = ps.executeQuery();){
                if (!result.next()) return null;
                Object object = result.getObject(column);
                return object;
            }
        }
        catch (SQLException e) {
            this.log("Failed to get value from database", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getValue(Table table, String sql, String column, Object ... args) {
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(sql);){
            for (int i = 0; i < args.length; ++i) {
                Object object = args[i];
                ps.setObject(i + 1, object);
            }
            try (ResultSet result = ps.executeQuery();){
                if (!result.next()) return null;
                Object object = result.getObject(column);
                return object;
            }
        }
        catch (SQLException e) {
            this.log("Failed to get value from database", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getRow(Table table, String index, Object value) {
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(SQL_SELECT_ALL + table.getName() + SQL_WHERE + index + "=?");){
            ps.setObject(1, value);
            try (ResultSet result = ps.executeQuery();){
                if (!result.next()) return Collections.emptyMap();
                ResultSetMetaData metaData = result.getMetaData();
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    row.put(metaData.getColumnName(i), result.getObject(i));
                }
                HashMap<String, Object> hashMap = row;
                return hashMap;
            }
        }
        catch (SQLException e) {
            this.log("Failed to get data from database", e);
        }
        return Collections.emptyMap();
    }

    /*
     * Exception decompiling
     */
    public List<Map<String, Object>> getAllRows(Table table) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean contains(Table table, String index, Object value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void update(Table table, String index, String toUpdate, Object indexValue, Object updateValue, String extra) {
        try (Connection connection = this.getConnection();){
            String update = extra.isEmpty() ? "?" : String.valueOf(updateValue) + extra;
            try (PreparedStatement ps = connection.prepareStatement("UPDATE " + table.getName() + " SET " + toUpdate + "=" + update + SQL_WHERE + index + "=?;");){
                if (extra.isEmpty()) {
                    ps.setObject(1, updateValue);
                    ps.setObject(2, indexValue);
                } else {
                    ps.setObject(1, indexValue);
                }
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.log("Failed to update database", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int update(Table table, String sql, Object ... args) {
        try (Connection connection = this.getConnection();){
            int n;
            block15: {
                PreparedStatement ps = connection.prepareStatement(sql);
                try {
                    for (int i = 0; i < args.length; ++i) {
                        Object object = args[i];
                        ps.setObject(i + 1, object);
                    }
                    n = ps.executeUpdate();
                    if (ps == null) break block15;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return n;
        }
        catch (SQLException e) {
            this.log("Failed to get value from database", e);
            return 0;
        }
    }

    public void update(Table table, String index, String toUpdate, Object indexValue, Object updateValue) {
        this.update(table, index, toUpdate, indexValue, updateValue, "");
    }

    public boolean updateValues(Table table, String index, Object indexValue, Collection<String> columns, Collection<Object> values) {
        boolean bl;
        block17: {
            Connection connection = this.getConnection();
            try {
                StringBuilder updateString = new StringBuilder();
                int i = 0;
                for (String col : columns) {
                    updateString.append(col + "=?");
                    if (++i >= columns.size()) continue;
                    updateString.append(",");
                }
                try (PreparedStatement ps = connection.prepareStatement("UPDATE " + table.getName() + " SET " + String.valueOf(updateString) + SQL_WHERE + index + "=?;");){
                    i = 0;
                    for (Object object : values) {
                        ps.setObject(++i, object);
                    }
                    ps.setObject(values.size() + 1, indexValue);
                    ps.executeUpdate();
                }
                bl = true;
                if (connection == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.log("Failed to update database", e);
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    public void remove(Table table, String index, Object value) {
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement("DELETE FROM " + table.getName() + SQL_WHERE + index + "=?;");){
            ps.setObject(1, value);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.log("Failed to remove from database", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeCountQuery(Table table, String where, Object ... args) {
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement("SELECT COUNT(*) FROM " + table.getName() + " " + where);){
            for (int i = 0; i < args.length; ++i) {
                ps.setObject(i + 1, args[i]);
            }
            try (ResultSet result = ps.executeQuery();){
                if (!result.next()) return 0;
                int n = result.getInt(1);
                return n;
            }
        }
        catch (SQLException e) {
            this.log("Failed to execute count query: " + where, e);
        }
        return 0;
    }

    @Nullable
    public Table getTable(String tableName) {
        return this.tableRegister.get(tableName);
    }

    public Connection getConnection() throws SQLException {
        return this.connectionPool.getConnection();
    }

    public void close() {
        this.setLogLevel(Level.WARN);
        this.connectionPool.close();
        this.setLogLevel(Level.INFO);
    }

    public DatabaseConfigBuilder.DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    private void setLogLevel(Level level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        ctx.getConfiguration().getLoggerConfig("com.zaxxer.hikari.HikariDataSource").setLevel(level);
    }

    private StringBuilder getValueParameteres(Collection<Object> values) {
        StringBuilder valueParams = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            valueParams.append("?");
            if (i >= values.size() - 1) continue;
            valueParams.append(",");
        }
        return valueParams;
    }

    private void log(String message, Throwable t) {
        Log.severe(message, t);
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }
}

