/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager.listener;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.chancesd.pvpmanager.manager.DependencyManager;
import me.chancesd.pvpmanager.manager.PlayerManager;
import me.chancesd.pvpmanager.player.CombatPlayer;
import me.chancesd.pvpmanager.sdutils.scheduler.ScheduleUtils;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import me.chancesd.pvpmanager.setting.Conf;
import me.chancesd.pvpmanager.setting.Lang;
import me.chancesd.pvpmanager.tasks.RegionCheckTask;
import me.chancesd.pvpmanager.utils.CombatUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class MoveListener1_9
implements Listener {
    private final PlayerManager playerManager;
    private final DependencyManager depManager;
    private final Cache<UUID, Player> cache = CacheBuilder.newBuilder().weakValues().expireAfterWrite(1L, TimeUnit.SECONDS).build();
    private final double pushbackForce;

    public MoveListener1_9(PlayerManager playerManager, DependencyManager depManager) {
        this.playerManager = playerManager;
        this.depManager = depManager;
        double force = Conf.PUSHBACK_FORCE.asDouble();
        if (force > 4.0) {
            Log.infoColor(String.valueOf(ChatColor.RED) + "Pushback force too high, setting it to 4");
            this.pushbackForce = 4.0;
        } else if (force < 0.1) {
            Log.infoColor(String.valueOf(ChatColor.RED) + "Pushback force too low, setting it to 0.1");
            this.pushbackForce = 0.1;
        } else {
            this.pushbackForce = force;
        }
        RegionCheckTask regionCheckTask = new RegionCheckTask(playerManager, depManager);
        Bukkit.getPluginManager().registerEvents((Listener)regionCheckTask, (Plugin)playerManager.getPlugin());
        ScheduleUtils.runPlatformAsyncTimer((Runnable)((Object)regionCheckTask), 20L, 20L);
    }

    @EventHandler(ignoreCancelled=true)
    public final void onPlayerMove(PlayerMoveEvent event) {
        Location locTo = event.getTo();
        Location locFrom = event.getFrom();
        if (locTo == null || locFrom.getBlockX() == locTo.getBlockX() && locFrom.getBlockZ() == locTo.getBlockZ() && locFrom.getBlockY() == locTo.getBlockY()) {
            return;
        }
        Player player = event.getPlayer();
        CombatPlayer combatPlayer = this.playerManager.get(player);
        if (!combatPlayer.isInCombat()) {
            return;
        }
        if (!this.depManager.canAttackAt(null, locTo) && this.depManager.canAttackAt(null, locFrom)) {
            Vector newVel = locFrom.toVector().subtract(locTo.toVector());
            newVel.setY(0).normalize().multiply(this.pushbackForce).setY(0.5);
            CombatUtils.checkGlide(combatPlayer);
            player.setVelocity(this.sanitizeVector(newVel));
            if (!this.cache.asMap().containsKey(player.getUniqueId())) {
                combatPlayer.message(Lang.PUSHBACK_WARNING, new Object[0]);
                player.getWorld().playEffect(player.getEyeLocation(), Effect.SMOKE, 3);
                this.cache.put((Object)player.getUniqueId(), (Object)player);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            return;
        }
        Player player = event.getPlayer();
        CombatPlayer pvplayer = this.playerManager.get(player);
        Location locTo = event.getTo();
        Location locFrom = event.getFrom();
        if (pvplayer.isInCombat() && !this.depManager.canAttackAt(null, locTo) && this.depManager.canAttackAt(null, locFrom)) {
            event.setCancelled(true);
            pvplayer.message(Lang.PUSHBACK_WARNING, new Object[0]);
        }
    }

    @NotNull
    private Vector sanitizeVector(@NotNull Vector vel) {
        if (Double.isNaN(vel.getX())) {
            vel.setX(0);
        }
        if (Double.isNaN(vel.getZ())) {
            vel.setZ(0);
        }
        return vel;
    }
}

