/*
 * Decompiled with CFR 0.152.
 */
package me.chancesd.pvpmanager;

import me.chancesd.pvpmanager.command.Announce;
import me.chancesd.pvpmanager.command.Newbie;
import me.chancesd.pvpmanager.command.PM;
import me.chancesd.pvpmanager.command.PvP;
import me.chancesd.pvpmanager.command.PvPGlobal;
import me.chancesd.pvpmanager.command.PvPInfo;
import me.chancesd.pvpmanager.command.PvPList;
import me.chancesd.pvpmanager.command.PvPOverride;
import me.chancesd.pvpmanager.command.PvPStatus;
import me.chancesd.pvpmanager.command.Tag;
import me.chancesd.pvpmanager.command.Untag;
import me.chancesd.pvpmanager.library.metrics.CustomMetrics;
import me.chancesd.pvpmanager.listener.BlockedActionsListener;
import me.chancesd.pvpmanager.listener.EntityListener;
import me.chancesd.pvpmanager.listener.EntityListener1_20_4;
import me.chancesd.pvpmanager.listener.EntityListener1_9;
import me.chancesd.pvpmanager.listener.PlayerListener;
import me.chancesd.pvpmanager.listener.PlayerListener1_11;
import me.chancesd.pvpmanager.manager.ConfigManager;
import me.chancesd.pvpmanager.manager.DependencyManager;
import me.chancesd.pvpmanager.manager.PlayerManager;
import me.chancesd.pvpmanager.manager.StorageManager;
import me.chancesd.pvpmanager.manager.UpdateManager;
import me.chancesd.pvpmanager.manager.WorldManager;
import me.chancesd.pvpmanager.sdutils.command.BaseCommand;
import me.chancesd.pvpmanager.sdutils.plugin.SDPlugin;
import me.chancesd.pvpmanager.sdutils.scheduler.ScheduleUtils;
import me.chancesd.pvpmanager.sdutils.utils.Log;
import me.chancesd.pvpmanager.sdutils.utils.MCVersion;
import me.chancesd.pvpmanager.setting.Lang;
import org.bukkit.ChatColor;
import org.bukkit.command.PluginCommand;

public class PvPManager
extends SDPlugin {
    private ConfigManager configM;
    private PlayerManager playerManager;
    private UpdateManager updateManager;
    private StorageManager storageManager;
    private DependencyManager dependencyManager;
    private WorldManager worldManager;
    private EntityListener entityListener;
    private static PvPManager instance;

    @Override
    public void onPluginLoad() {
        Log.setup(this.getLogger(), "\u00a77[\u00a74\u00a7lPvP\u00a78\u00a7lManager\u00a77]");
        instance = this;
        this.dependencyManager = new DependencyManager();
        this.dependencyManager.onLoadSetup();
    }

    @Override
    public void onPluginEnable() {
        long start = System.currentTimeMillis();
        if (ScheduleUtils.isFolia()) {
            Log.infoColor(String.valueOf(ChatColor.AQUA) + "Running on Folia. Support for Folia is still experimental");
            Log.infoColor(String.valueOf(ChatColor.AQUA) + "Please report any errors you find, most likely nobody reported them yet as not many people use Folia");
        }
        this.configM = new ConfigManager(this);
        Lang.setup(this);
        this.storageManager = new StorageManager(this);
        this.dependencyManager.onEnableSetup();
        this.updateManager = new UpdateManager(this);
        this.worldManager = new WorldManager(this);
        this.playerManager = new PlayerManager(this);
        this.startListeners();
        this.registerCommands();
        this.startMetrics();
        Log.infoColor(String.valueOf(ChatColor.GREEN) + this.getDescription().getFullName() + " enabled " + String.valueOf(ChatColor.GRAY) + "(" + (System.currentTimeMillis() - start) + " ms)");
    }

    @Override
    public void onPluginDisable() {
        this.playerManager.handlePluginDisable();
        this.dependencyManager.onDisableCleanup();
        this.storageManager.shutdown();
        instance = null;
    }

    private void startListeners() {
        if (MCVersion.isAtLeast(MCVersion.V1_9)) {
            this.registerListener(new EntityListener1_9(this.playerManager));
        }
        this.entityListener = new EntityListener(this.playerManager);
        this.registerListener(this.entityListener);
        if (MCVersion.isAtLeast(MCVersion.V1_11_2)) {
            this.registerListener(new PlayerListener1_11(this.playerManager));
        }
        this.registerListener(new PlayerListener(this.playerManager));
        this.registerListener(new BlockedActionsListener(this.playerManager));
        if (MCVersion.isAtLeast(MCVersion.V1_20_4)) {
            new EntityListener1_20_4(this.playerManager);
        }
        this.dependencyManager.startListeners(this);
    }

    private void registerCommands() {
        BaseCommand.setGlobalDefaults(sender -> Lang.ERROR_PERMISSION.msg(), sender -> Lang.ERROR_NOT_PLAYER.msg(), xva$0 -> Lang.ERROR_PLAYER_NOT_FOUND.msg((String)xva$0));
        this.registerCommand("pvp", (PluginCommand cmd) -> new PvP((PluginCommand)cmd, this.playerManager));
        this.registerCommand("newbie", (PluginCommand cmd) -> new Newbie((PluginCommand)cmd, this.playerManager));
        this.registerCommand("pvpmanager", (PluginCommand cmd) -> new PM((PluginCommand)cmd, this));
        this.registerCommand("pvpoverride", (PluginCommand cmd) -> new PvPOverride((PluginCommand)cmd, this.playerManager));
        this.registerCommand("pvpinfo", (PluginCommand cmd) -> new PvPInfo((PluginCommand)cmd, this.playerManager));
        this.registerCommand("pvplist", (PluginCommand cmd) -> new PvPList((PluginCommand)cmd, this.playerManager));
        this.registerCommand("pvpstatus", (PluginCommand cmd) -> new PvPStatus((PluginCommand)cmd, this.playerManager));
        this.registerCommand("pvptag", (PluginCommand cmd) -> new Tag((PluginCommand)cmd, this.playerManager));
        this.registerCommand("untag", (PluginCommand cmd) -> new Untag((PluginCommand)cmd, this.playerManager));
        this.registerCommand("announce", Announce::new);
        this.registerCommand("pvpglobal", (PluginCommand cmd) -> new PvPGlobal((PluginCommand)cmd, this.playerManager));
    }

    private void startMetrics() {
        new CustomMetrics(this);
    }

    public EntityListener getEntityListener() {
        return this.entityListener;
    }

    public ConfigManager getConfigM() {
        return this.configM;
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    public static PvPManager getInstance() {
        return instance;
    }
}

