/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.game.checkers;

import com.shanebeestudios.skbee.game.checkers.Piece;
import com.shanebeestudios.skbee.game.checkers.PieceColor;
import com.shanebeestudios.skbee.game.checkers.PieceType;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

public class Game
extends JPanel
implements MouseInputListener {
    public ArrayList<int[]> moves = new ArrayList();
    public Piece[] pieces = new Piece[64];
    public int selectedX = -1;
    public int selectedY = -1;
    public int offset;

    public Game(int realHeight) {
        this.populateTiles();
        this.offset = realHeight - 512;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.renderTiles(g);
        this.renderPieces(g);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX() / 64;
        int y = (e.getY() - this.offset) / 64;
        Piece selectedPiece = this.getSelectedPiece();
        if (!selectedPiece.isNull() && this.hasMove(x, y)) {
            if (Math.abs(selectedPiece.x - x) == 2) {
                int directionX = (x - this.selectedX) / 2;
                int directionY = (y - this.selectedY) / 2;
                Piece capturedPiece = this.getPiece(this.selectedX + directionX, this.selectedY + directionY);
                this.clearPiece(capturedPiece);
            }
            if (y == 0) {
                selectedPiece.type = PieceType.QUEEN_BEE;
            }
            this.movePiece(selectedPiece, x, y);
            this.selectedX = -1;
            this.selectedY = -1;
            this.moves.clear();
            boolean hasPiece = false;
            for (Piece piece : this.pieces) {
                if (piece.color != PieceColor.BLUE || piece.getMoves(this).isEmpty()) continue;
                hasPiece = true;
                break;
            }
            while (hasPiece) {
                ArrayList<int[]> moves;
                Piece piece = this.pieces[(int)Math.floor(Math.random() * 64.0)];
                if (piece.color != PieceColor.BLUE || (moves = piece.getMoves(this)).isEmpty()) continue;
                int[] move = moves.get((int)Math.floor(Math.random() * (double)moves.size()));
                if (Math.abs(piece.x - move[0]) == 2) {
                    int directionX = (move[0] - piece.x) / 2;
                    int directionY = (move[1] - piece.y) / 2;
                    Piece capturedPiece = this.getPiece(piece.x + directionX, piece.y + directionY);
                    this.clearPiece(capturedPiece);
                }
                if (move[1] == 7) {
                    piece.type = PieceType.QUEEN_BEE;
                }
                this.movePiece(piece, move[0], move[1]);
                break;
            }
            this.repaint();
            return;
        }
        if (this.selectedX != x || this.selectedY != y) {
            this.selectedX = x;
            this.selectedY = y;
            this.moves.clear();
            Piece piece = this.getPiece(x, y);
            if (!piece.isNull() && piece.color == PieceColor.RED) {
                this.moves = piece.getMoves(this);
            }
        } else {
            this.selectedX = -1;
            this.selectedY = -1;
            this.moves.clear();
        }
        this.repaint();
    }

    private void populateTiles() {
        for (int i = 0; i < 64; ++i) {
            int y = i / 8;
            int x = i - y * 8;
            this.pieces[i] = new Piece(x, y);
            if (i <= 23 && (x + y) % 2 == 1) {
                this.pieces[i] = new Piece(PieceType.WORKER_BEE, PieceColor.BLUE, x, y);
            }
            if (i < 40 || (x + y) % 2 != 1) continue;
            this.pieces[i] = new Piece(PieceType.WORKER_BEE, PieceColor.RED, x, y);
        }
    }

    private void renderPieces(Graphics graphics) {
        for (Piece piece : this.pieces) {
            if (piece.isNull()) continue;
            Image image = switch (piece.color) {
                default -> throw new IncompatibleClassChangeError();
                case PieceColor.RED -> piece.type.red;
                case PieceColor.BLUE -> piece.type.blue;
            };
            graphics.drawImage(image, piece.x * 64, piece.y * 64, 64, 64, null);
        }
    }

    private void renderTiles(Graphics graphics) {
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                graphics.setColor((x + y) % 2 == 0 ? Color.YELLOW : Color.BLACK);
                if (this.hasMove(x, y)) {
                    graphics.setColor(Color.RED);
                }
                if (x == this.selectedX && y == this.selectedY) {
                    graphics.setColor(Color.GREEN);
                }
                graphics.fillRect(x * 64, y * 64, 64, 64);
            }
        }
    }

    private Piece getSelectedPiece() {
        if (this.selectedX == -1 && this.selectedY == -1) {
            return new Piece(this.selectedX, this.selectedY);
        }
        return this.getPiece(this.selectedX, this.selectedY);
    }

    private boolean hasMove(int x, int y) {
        for (int[] move : this.moves) {
            if (move[0] != x || move[1] != y) continue;
            return true;
        }
        return false;
    }

    private void movePiece(Piece piece, int x, int y) {
        this.pieces[y * 8 + x] = piece;
        this.clearPiece(piece);
        piece.x = x;
        piece.y = y;
    }

    private void clearPiece(Piece piece) {
        this.pieces[piece.y * 8 + piece.x] = new Piece(piece.x, piece.y);
    }

    public Piece getPiece(int x, int y) {
        return this.pieces[y * 8 + x];
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

