/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldcreator.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.elements.worldcreator.objects.BeeWorldCreator;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="World Creator Options")
@Description(value={"Set different options for world creators. See SkBee wiki for more details.", "NOTE: 'load on start' will bypass 'auto-load-custom-worlds' in SkBee config.", "`fixed spawn location` = This is used to override Minecraft attempting to find a spawn location (Which takes a LONG time), this option can greatly speed up world creation."})
@Examples(value={"set {_w} to a new world creator named \"my-world\"", "set environment option of {_w} to nether", "set world type option of {_w} to flat", "set should generate structures option of {_w} to true", "set load on start option of {_w} to false", "set fixed spawn location option of {_w} to location(1,100,1)", "load world from creator {_w}"})
@Since(value={"1.8.0"})
public class ExprWorldCreatorOption
extends SimplePropertyExpression<BeeWorldCreator, Object> {
    private int pattern;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.mark;
        this.setExpr(exprs[0]);
        return true;
    }

    @Nullable
    public Object convert(@NotNull BeeWorldCreator creator) {
        return switch (this.pattern) {
            case 1 -> creator.getWorldType();
            case 2 -> Long.valueOf(creator.getSeed());
            case 3 -> creator.getGeneratorSettings();
            case 4 -> creator.getGenerator();
            case 5 -> Boolean.valueOf(creator.isGenStructures());
            case 6 -> Boolean.valueOf(creator.isHardcore());
            case 7 -> Boolean.valueOf(creator.isKeepSpawnLoaded());
            case 8 -> Boolean.valueOf(creator.isLoadOnStart());
            case 9 -> null;
            default -> creator.getEnvironment();
        };
    }

    public Class<?>[] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return switch (this.pattern) {
                case 1 -> (Class[])CollectionUtils.array((Object[])new Class[]{WorldType.class});
                case 2 -> (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
                case 3, 4 -> (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
                case 5, 6, 7, 8 -> (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
                case 9 -> (Class[])CollectionUtils.array((Object[])new Class[]{Location.class});
                default -> (Class[])CollectionUtils.array((Object[])new Class[]{World.Environment.class});
            };
        }
        return null;
    }

    public void change(@NotNull Event event, @Nullable Object[] delta, @NotNull Changer.ChangeMode mode) {
        Object object = delta != null ? delta[0] : null;
        BeeWorldCreator creator = (BeeWorldCreator)this.getExpr().getSingle(event);
        if (creator == null) {
            return;
        }
        switch (this.pattern) {
            case 1: {
                if (!(object instanceof WorldType)) break;
                creator.setWorldType((WorldType)object);
                break;
            }
            case 2: {
                if (!(object instanceof Number)) break;
                creator.setSeed(((Number)object).longValue());
                break;
            }
            case 3: {
                if (!(object instanceof String)) break;
                creator.setGeneratorSettings((String)object);
                break;
            }
            case 4: {
                if (!(object instanceof String)) break;
                creator.setGenerator((String)object);
                break;
            }
            case 5: {
                if (!(object instanceof Boolean)) break;
                creator.setGenStructures((Boolean)object);
                break;
            }
            case 6: {
                if (!(object instanceof Boolean)) break;
                creator.setHardcore((Boolean)object);
                break;
            }
            case 7: {
                if (!(object instanceof Boolean)) break;
                creator.setKeepSpawnLoaded((Boolean)object);
                break;
            }
            case 8: {
                if (!(object instanceof Boolean)) break;
                Boolean loadOnStart = (Boolean)object;
                creator.setLoadOnStart(loadOnStart);
                break;
            }
            case 9: {
                if (!(object instanceof Location)) break;
                Location location = (Location)object;
                creator.setFixedSpawnLocation(location);
                break;
            }
            default: {
                if (!(object instanceof World.Environment)) break;
                creator.setEnvironment((World.Environment)object);
            }
        }
    }

    @NotNull
    public Class<?> getReturnType() {
        return switch (this.pattern) {
            case 1 -> WorldType.class;
            case 2 -> Number.class;
            case 3, 4 -> String.class;
            case 5, 6, 7 -> Boolean.class;
            default -> World.Environment.class;
        };
    }

    @NotNull
    protected String getPropertyName() {
        String option = switch (this.pattern) {
            case 1 -> "world type";
            case 2 -> "seed";
            case 3 -> "generator settings";
            case 4 -> "generator";
            case 5 -> "should generate structures";
            case 6 -> "hardcore";
            case 7 -> "keep spawn loaded";
            case 8 -> "load on start";
            case 9 -> "fixed spawn location";
            default -> "environment";
        };
        return option + " option";
    }

    static {
        ExprWorldCreatorOption.register(ExprWorldCreatorOption.class, Object.class, (String)"(environment|1:world type|2:world seed|3:gen[erator] settings|4:generator|5:should gen[erate] structures|6:[is] hardcore|7:keep spawn loaded|8:load on start|9:fixed spawn location) [option]", (String)"worldcreator");
    }
}

