/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldborder.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="WorldBorder")
@Description(value={"Represents the world border of a player/world, or create a virtual world border.", "World border of a world can not be changed.", "World border of a player can be set to a virtual world border.", "Resetting border of player will set back to the world border of the world the player is in.", "If you would like to reset default values of a border, you will have to do it in a var (see examples).", "Multiple players can share a virtual world border.", "NOTE: Virtual world borders do not seem to be persistent (ie: restarts, quitting, death, world change).", "NOTE: Virtual world borders were added in MC 1.18.x+"})
@Examples(value={"set world border of player to virtual world border", "set border center of world border of player to location of player", "set size of world border of player to 100", "reset world border of player #will remove the player's virtual border", "set {_w} to world border of player", "reset {_w} #will reset default values of the border"})
@Since(value={"1.17.0"})
public class ExprWorldBorder
extends SimpleExpression<WorldBorder> {
    private static final boolean SUPPORTS_VIRTUAL_BORDER = Skript.methodExists(Player.class, (String)"getWorldBorder", (Class[])new Class[0]);
    private int pattern;
    private Expression<Object> object;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (i == 1 && !SUPPORTS_VIRTUAL_BORDER) {
            Skript.error((String)"Virtual world borders are not supported on your server version.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.pattern = i;
        this.object = i == 0 ? exprs[0] : null;
        return true;
    }

    @Nullable
    protected WorldBorder[] get(Event event) {
        ArrayList<WorldBorder> borders = new ArrayList<WorldBorder>();
        if (this.pattern == 1 && SUPPORTS_VIRTUAL_BORDER) {
            return new WorldBorder[]{Bukkit.createWorldBorder()};
        }
        for (Object object : this.object.getArray(event)) {
            if (object instanceof Player) {
                Player player = (Player)object;
                if (SUPPORTS_VIRTUAL_BORDER) {
                    borders.add(player.getWorldBorder());
                    continue;
                }
            }
            if (!(object instanceof World)) continue;
            World world = (World)object;
            borders.add(world.getWorldBorder());
        }
        return borders.toArray(new WorldBorder[0]);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.pattern == 0 && !SUPPORTS_VIRTUAL_BORDER) {
            Skript.error((String)"Virtual world borders are not supported on your server version therefor a border cannot be changed", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return null;
        }
        if (this.pattern == 0 && (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET)) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{WorldBorder.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        WorldBorder border = delta != null ? (WorldBorder)delta[0] : null;
        for (Object object : this.object.getArray(event)) {
            if (object instanceof Player) {
                Player player = (Player)object;
                if (mode == Changer.ChangeMode.SET) {
                    if (border != null && border.getWorld() != null && border.getWorld() != player.getWorld()) continue;
                    player.setWorldBorder(border);
                    continue;
                }
                player.setWorldBorder(null);
                continue;
            }
            if (!(object instanceof World)) continue;
            World world = (World)object;
            if (mode != Changer.ChangeMode.RESET) continue;
            world.getWorldBorder().reset();
        }
    }

    public boolean isSingle() {
        if (this.pattern == 0) {
            return this.object.isSingle();
        }
        return true;
    }

    @NotNull
    public Class<? extends WorldBorder> getReturnType() {
        return WorldBorder.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        if (this.pattern == 0) {
            return "world border of " + this.object.toString(e, d);
        }
        return "virtual world border";
    }

    static {
        Skript.registerExpression(ExprWorldBorder.class, WorldBorder.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"world border of %players/worlds%", "[new] virtual world border"});
    }
}

