/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.worldborder.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import org.bukkit.WorldBorder;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="WorldBorder - Expand/Shrink")
@Description(value={"Expand or shrink a world border.", "\nBY = adds/subtracts from current size of border.", "\nTO = sets to the specified size.", "\ntimespan = how long it will take the border to get to the new size."})
@Examples(value={"expand world border of player by 100 in 5 seconds", "shrink world border of world \"world\" to 100 in 10 seconds"})
@Since(value={"1.17.0"})
public class EffWorldBorderExpand
extends Effect {
    private boolean expand;
    private int pattern;
    private Expression<WorldBorder> worldBorders;
    private Expression<Number> size;
    private Expression<Timespan> timeSpan;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.expand = parseResult.mark == 0;
        this.pattern = i;
        this.worldBorders = exprs[0];
        this.size = exprs[1];
        this.timeSpan = exprs[2];
        return true;
    }

    protected void execute(Event event) {
        Timespan timeSpan;
        Number sizeNum = (Number)this.size.getSingle(event);
        if (sizeNum == null) {
            return;
        }
        long speed = 0L;
        if (this.timeSpan != null && (timeSpan = (Timespan)this.timeSpan.getSingle(event)) != null) {
            speed = timeSpan.getAs(Timespan.TimePeriod.TICK) / 20L;
        }
        double size = sizeNum.doubleValue();
        for (WorldBorder border : (WorldBorder[])this.worldBorders.getArray(event)) {
            if (this.pattern == 0) {
                this.expand(border, size, speed);
                continue;
            }
            if (size < 0.0) {
                size = 0.0;
            }
            border.setSize(size, speed);
        }
    }

    private void expand(WorldBorder worldBorder, double size, long seconds) {
        double oldSize = worldBorder.getSize();
        if (this.expand) {
            worldBorder.setSize(oldSize + size, seconds);
        } else {
            double newSize = oldSize - size;
            if (newSize < 0.0) {
                newSize = 0.0;
            }
            worldBorder.setSize(newSize, seconds);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String expand = this.expand ? "expand" : "shrink";
        String to = this.pattern == 1 ? "to" : "by";
        String size = this.size.toString(e, d);
        String time = this.timeSpan != null ? "in " + this.timeSpan.toString(e, d) : "";
        return String.format("%s %s %s %s %s", expand, this.worldBorders.toString(e, d), to, size, time);
    }

    static {
        Skript.registerEffect(EffWorldBorderExpand.class, (String[])new String[]{"(expand|1:shrink) %worldborders% by %number% [in %-timespan%]", "(expand|1:shrink) %worldborders% to %number% [in %-timespan%]"});
    }
}

