/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.virtualfurnace.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.virtualfurnace.api.property.FurnaceProperties;
import com.shanebeestudios.skbee.api.virtualfurnace.api.property.Properties;
import com.shanebeestudios.skbee.elements.virtualfurnace.type.Types;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="VirtualFurnace - Furnace Item")
@Description(value={"Get a virtual furnace item. This will be any item with a linked virtual furnace, allowing players to access a portable furnace wherever they go. The speed multipliers will allow your furnace item to cook faster or burn fuel faster. Ex: 1.0 will burn at normal speed as defined by the recipes, where as 2.0 will burn twice as fast. Omitting these values will default to 1.0.GUI name will be the name that shows up in the furnace GUI"})
@Examples(value={"give player a virtual furnace item as diamond named \"MyFurnace\" with gui name \"PORTABLE FURNACE\" with cook speed multiplier 1.5"})
@Since(value={"1.3.0"})
public class ExprVirtualFurnaceItem
extends SimpleExpression<ItemType> {
    private int pattern;
    private Expression<ItemType> itemType;
    private Expression<String> name;
    private Expression<Number> cookSpeed;
    private Expression<Number> fuelSpeed;
    private Expression<Properties> properties;
    private boolean glowing;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parse) {
        this.pattern = matchedPattern;
        this.itemType = exprs[0];
        this.name = exprs[1];
        if (matchedPattern == 0) {
            this.cookSpeed = exprs[2];
            this.fuelSpeed = exprs[3];
        } else {
            this.properties = exprs[2];
        }
        this.glowing = parse.hasTag("glowing");
        return true;
    }

    protected ItemType @Nullable [] get(Event event) {
        FurnaceProperties furnaceProperties;
        ItemType itemType = (ItemType)this.itemType.getSingle(event);
        if (itemType == null) {
            return null;
        }
        ItemStack itemStack = itemType.getRandom();
        if (this.pattern == 0) {
            double cookspeed = this.cookSpeed != null ? ((Number)this.cookSpeed.getSingle(event)).doubleValue() : 1.0;
            double fuelSpeed = this.fuelSpeed != null ? ((Number)this.fuelSpeed.getSingle(event)).doubleValue() : 1.0;
            String key = "key_" + String.valueOf(itemStack.getType()) + "_" + cookspeed + "_" + fuelSpeed;
            furnaceProperties = new FurnaceProperties(key).cookMultiplier(cookspeed).fuelMultiplier(fuelSpeed);
        } else {
            FurnaceProperties p;
            Object cookspeed = this.properties.getSingle(event);
            furnaceProperties = cookspeed instanceof FurnaceProperties ? (p = (FurnaceProperties)cookspeed) : FurnaceProperties.FURNACE;
        }
        String name = this.name != null ? (String)this.name.getSingle(event) : "uh-oh";
        ItemStack furnaceItem = Types.FURNACE_MANAGER.createItemWithFurnace(name, furnaceProperties, itemStack, this.glowing);
        return new ItemType[]{new ItemType(furnaceItem)};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String properties = this.pattern == 0 ? (String)(this.cookSpeed != null ? " with cook speed " + this.cookSpeed.toString(e, d) : "") + (String)(this.fuelSpeed != null ? " with fuel speed " + this.fuelSpeed.toString(e, d) : "") : " with properties " + this.properties.toString(e, d);
        return (this.glowing ? "glowing " : "") + "virtual furnace item as " + this.itemType.toString(e, d) + " with inventory name " + this.name.toString(e, d) + properties;
    }

    static {
        Skript.registerExpression(ExprVirtualFurnaceItem.class, ItemType.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [(:glowing)] virtual furnace item as %itemtype% with (inventory|gui) name %string% [[and ]with cook speed multiplier %number%] [[and ]with fuel speed multiplier %number%]", "[a] [(:glowing)] virtual furnace item as %itemtype% with (inventory|gui) name %string% ", "with [[furnace ]properties] %-machineproperty%"});
    }
}

