/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.virtualfurnace.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Furnace;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Machine;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="VirtualFurnace - Inventory")
@Description(value={"Get the inventory of a virtual furnace. Can be used to open for a player."})
@Examples(value={"set {_inv} to virtual furnace inventory of {_furnace}", "open {_inv} to player"})
@Since(value={"3.3.0"})
public class ExprVirtualFurnaceInventory
extends SimplePropertyExpression<Machine, Inventory> {
    @Nullable
    public Inventory convert(Machine machine) {
        if (machine instanceof Furnace) {
            Furnace furnace = (Furnace)machine;
            return furnace.getInventory();
        }
        return null;
    }

    @NotNull
    public Class<? extends Inventory> getReturnType() {
        return Inventory.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "machine inventory";
    }

    static {
        ExprVirtualFurnaceInventory.register(ExprVirtualFurnaceInventory.class, Inventory.class, (String)"[virtual] (machine|furnace) inventory", (String)"machines");
    }
}

