/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.virtualfurnace.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.virtualfurnace.api.machine.Furnace;
import com.shanebeestudios.skbee.api.virtualfurnace.api.property.FurnaceProperties;
import com.shanebeestudios.skbee.api.virtualfurnace.api.property.Properties;
import com.shanebeestudios.skbee.elements.virtualfurnace.type.Types;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="VirtualFurnace - Create")
@Description(value={"Create a virtual furnace. When properties are not defined, default vanilla Minecraft properties are used."})
@Examples(value={"set {_furnace} to virtual furnace named \"Le Furnace\"", "", "set {_prop} to default furnace properties", "set {_furnace} to virtual furnace named \"Potato\" with properties {_prop}"})
@Since(value={"3.3.0"})
public class ExprVirtualFurnaceCreate
extends SimpleExpression<Furnace> {
    private Expression<String> name;
    private Expression<Properties> properties;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        this.properties = exprs[1];
        return true;
    }

    protected Furnace @Nullable [] get(Event event) {
        String name = (String)this.name.getSingle(event);
        if (name == null) {
            return null;
        }
        Properties properties = FurnaceProperties.FURNACE;
        if (this.properties != null) {
            properties = (Properties)this.properties.getSingle(event);
        }
        if (properties instanceof FurnaceProperties) {
            FurnaceProperties furnaceProperties = properties;
            Furnace furnace = Types.FURNACE_MANAGER.createFurnace(name, furnaceProperties);
            return new Furnace[]{furnace};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Furnace> getReturnType() {
        return Furnace.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String name = this.name.toString(e, d);
        String properties = this.properties != null ? " with properties " + this.properties.toString(e, d) : "";
        return "virtual furnace named " + name + properties;
    }

    static {
        Skript.registerExpression(ExprVirtualFurnaceCreate.class, Furnace.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"virtual furnace (named|with name) %string% [with [[furnace ]properties] %-machineproperty%]"});
    }
}

