/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.villager.type;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import com.shanebeestudios.skbee.api.util.SkriptUtils;
import java.util.ArrayList;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.MerchantRecipe;
import org.jetbrains.annotations.NotNull;

public class Types {
    static {
        if (Classes.getExactClassInfo(Merchant.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Merchant.class, "merchant").user(new String[]{"merchants?"}).name("Merchant").description(new String[]{"Represents a merchant.", "A merchant is a special type of inventory which can facilitate custom trades between items."}).since("1.17.0").after(new String[]{"entitydata"}).parser((Parser)new Parser<Merchant>(){

                public boolean canParse(ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(Merchant merchant, int i) {
                    if (merchant instanceof AbstractVillager) {
                        AbstractVillager villager = (AbstractVillager)merchant;
                        return EntityData.toString((Entity)villager, (int)i);
                    }
                    return "Merchant{trader=" + Classes.toString((Object)merchant.getTrader()) + "}";
                }

                @NotNull
                public String toVariableNameString(Merchant merchant) {
                    return "merchant";
                }
            }));
        }
        if (Classes.getExactClassInfo(MerchantInventory.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(MerchantInventory.class, "merchantinventory").user(new String[]{"merchant ?inventor(y|ies)"}).name("Merchant Inventory").description(new String[]{"Represents a trading inventory between a player and a merchant.", "The holder of this Inventory is the owning Villager, or null if the player is trading with a custom merchant."}).since("1.17.0").parser(SkriptUtils.getDefaultParser()));
        }
        if (Classes.getExactClassInfo(MerchantRecipe.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(MerchantRecipe.class, "merchantrecipe").user(new String[]{"merchant ?recipes?"}).name("Merchant Recipe").description(new String[]{"Represents a merchant's trade. Trades can take one or two ingredients, and provide one result."}).since("1.17.0").parser((Parser)new Parser<MerchantRecipe>(){

                public boolean canParse(ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(MerchantRecipe merchantRecipe, int i) {
                    String result = ItemType.toString((ItemStack)merchantRecipe.getResult());
                    ArrayList<String> ingredients = new ArrayList<String>();
                    for (ItemStack ingredient : merchantRecipe.getIngredients()) {
                        ingredients.add(ItemType.toString((ItemStack)ingredient));
                    }
                    int maxUses = merchantRecipe.getMaxUses();
                    int uses = merchantRecipe.getUses();
                    boolean reward = merchantRecipe.hasExperienceReward();
                    int villagerXP = merchantRecipe.getVillagerExperience();
                    float priceMultiplier = merchantRecipe.getPriceMultiplier();
                    int demand = merchantRecipe.getDemand();
                    int specialPrice = merchantRecipe.getSpecialPrice();
                    return String.format("MerchantRecipe{result=%s, maxUses=%s, ingredients=%s, uses=%s, reward=%s, villagerXP=%s, priceMultiplier=%s, demand=%s, specialPrice=%s}", result, maxUses, ingredients, uses, reward, villagerXP, Float.valueOf(priceMultiplier), demand, specialPrice);
                }

                @NotNull
                public String toVariableNameString(MerchantRecipe merchantRecipe) {
                    return "merchant recipe";
                }
            }));
        }
    }
}

