/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.villager.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Merchant - Recipes")
@Description(value={"Represents the recipes of a merchant. All recipes returns a list of all the recipes this merchant offers.", "You can also set/delete them or add to them. You can also get/set/delete a specific recipe.", "<b>note: when setting/deleting a specific merchant recipe the merchant MUST have a recipe in that slot</b>"})
@Examples(value={"add {_recipe} to merchant recipes of {_merchant}", "set merchant recipe 1 of {_merchant} to {_recipe}"})
@Since(value={"1.17.0"})
public class ExprMerchantRecipes
extends SimpleExpression<MerchantRecipe> {
    private Expression<?> merchants;
    private Expression<Number> recipe;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.merchants = exprs[matchedPattern];
        this.recipe = matchedPattern == 1 ? exprs[0] : null;
        return true;
    }

    protected MerchantRecipe @Nullable [] get(Event event) {
        ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
        if (this.recipe != null) {
            Number number = (Number)this.recipe.getSingle(event);
            if (number == null) {
                return null;
            }
            int recipe = number.intValue() - 1;
            if (recipe < 0) {
                return null;
            }
            for (Object obj : this.merchants.getArray(event)) {
                Merchant merchant;
                int recipeCount;
                if (!(obj instanceof Merchant) || (recipeCount = (merchant = (Merchant)obj).getRecipeCount()) == 0 || recipe > recipeCount - 1) continue;
                recipes.add(merchant.getRecipe(recipe));
            }
        } else {
            for (Object obj : this.merchants.getArray(event)) {
                if (!(obj instanceof Merchant)) continue;
                Merchant merchant = (Merchant)obj;
                recipes.addAll(merchant.getRecipes());
            }
        }
        return (MerchantRecipe[])recipes.toArray(MerchantRecipe[]::new);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.recipe == null) {
            return switch (mode) {
                case Changer.ChangeMode.ADD, Changer.ChangeMode.SET, Changer.ChangeMode.DELETE -> (Class[])CollectionUtils.array((Object[])new Class[]{MerchantRecipe[].class});
                default -> null;
            };
        }
        switch (mode) {
            case SET: 
            case DELETE: {
                return (Class[])CollectionUtils.array((Object[])new Class[]{MerchantRecipe.class});
            }
            case ADD: {
                Skript.error((String)"You can only add a merchant recipe if you're using the 'all merchant recipes' syntax.");
            }
        }
        return null;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        MerchantRecipe merchantRecipe;
        if (this.recipe == null) {
            ArrayList<MerchantRecipe> recipes = new ArrayList<MerchantRecipe>();
            if (delta != null) {
                for (Object object : delta) {
                    MerchantRecipe merchantRecipe2;
                    if (!(object instanceof MerchantRecipe) || (merchantRecipe2 = (MerchantRecipe)object).getIngredients().isEmpty()) continue;
                    recipes.add(merchantRecipe2);
                }
            }
            for (Object obj : this.merchants.getArray(event)) {
                if (!(obj instanceof Merchant)) continue;
                Merchant merchant = (Merchant)obj;
                ArrayList recipeCopy = new ArrayList(recipes);
                switch (mode) {
                    case ADD: {
                        recipeCopy.addAll(0, merchant.getRecipes());
                    }
                    case SET: 
                    case DELETE: {
                        merchant.setRecipes(recipeCopy);
                    }
                }
            }
            return;
        }
        if (mode == Changer.ChangeMode.ADD) {
            return;
        }
        Number num = (Number)this.recipe.getSingle(event);
        if (num == null) {
            return;
        }
        int recipeSlot = num.intValue() - 1;
        if (recipeSlot < 0) {
            return;
        }
        MerchantRecipe merchantRecipe3 = merchantRecipe = delta != null ? (MerchantRecipe)delta[0] : null;
        if (merchantRecipe != null && merchantRecipe.getIngredients().isEmpty()) {
            return;
        }
        block10: for (Object obj : this.merchants.getArray(event)) {
            Merchant merchant;
            int recipeCount;
            if (!(obj instanceof Merchant) || (recipeCount = (merchant = (Merchant)obj).getRecipeCount()) == 0 || recipeCount - 1 < recipeSlot) continue;
            switch (mode) {
                case SET: {
                    assert (merchantRecipe != null);
                    merchant.setRecipe(recipeSlot, merchantRecipe);
                    continue block10;
                }
                case DELETE: {
                    ArrayList updatedRecipes = new ArrayList(merchant.getRecipes());
                    if (updatedRecipes.size() < recipeSlot) continue block10;
                    updatedRecipes.remove(recipeSlot);
                    merchant.setRecipes(updatedRecipes);
                }
            }
        }
    }

    public boolean isSingle() {
        return this.recipe != null && this.merchants.isSingle();
    }

    @NotNull
    public Class<? extends MerchantRecipe> getReturnType() {
        return MerchantRecipe.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        if (this.recipe == null) {
            return "all merchant recipes of " + this.merchants.toString(e, d);
        }
        return "merchant recipe " + this.recipe.toString(e, d) + " of " + this.merchants.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprMerchantRecipes.class, MerchantRecipe.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[all] merchant recipes of %merchants/entities%", "merchant recipe %number% of %merchants/entities%"});
    }
}

