/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.tickmanager.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.ServerTickManager;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Server Tick - Tick Rate")
@Description(value={"Represents the tick rate of the server. Can be a value from `1.0` to `10000.0`.", "Supports fractional numbers, see examples.", "Default = 20.", "See [**Tick Command**](https://minecraft.wiki/w/Commands/tick) on McWiki for more details.", "Requires Minecraft 1.20.4+"})
@Examples(value={"set {_rate} to server tick rate", "set server tick rate to 100", "add 1.5 to server tick rate", "remove 3.75 from server tick rate", "reset server tick rate"})
@Since(value={"3.1.0"})
public class ExprServerTickRate
extends SimpleExpression<Number> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return true;
    }

    @Nullable
    protected Number[] get(Event e) {
        return new Number[]{Float.valueOf(Bukkit.getServerTickManager().getTickRate())};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE -> (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
            case Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        ServerTickManager tickManager = Bukkit.getServerTickManager();
        float newValue = 20.0f;
        float previousValue = tickManager.getTickRate();
        if (delta != null && (object = delta[0]) instanceof Number) {
            Number num = (Number)object;
            float changeValue = num.floatValue();
            if (mode == Changer.ChangeMode.SET) {
                newValue = changeValue;
            } else if (mode == Changer.ChangeMode.ADD) {
                newValue = previousValue + changeValue;
            } else if (mode == Changer.ChangeMode.REMOVE) {
                newValue = previousValue - changeValue;
            }
        }
        if (newValue >= 1.0f && newValue <= 10000.0f) {
            tickManager.setTickRate(newValue);
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "server tick rate";
    }

    static {
        Skript.registerExpression(ExprServerTickRate.class, Number.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"server tick rate"});
    }
}

