/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.tickmanager.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.ServerTickManager;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Server Tick - Step Server")
@Description(value={"Steps the game a certain amount of ticks if the server is currently frozen.", "Steps occur when the server is in a frozen state which can be started by either using", "the in game `/tick freeze` command or the `server frozen state` expression.", "See [**Tick Command**](https://minecraft.wiki/w/Commands/tick) on McWiki for more details.", "Requires Minecraft 1.20.4+"})
@Examples(value={"step game if frozen 10 ticks", "stop stepping game"})
@Since(value={"3.1.0"})
public class EffServerTickStep
extends Effect {
    private Expression<Timespan> ticks;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.ticks = matchedPattern == 0 ? exprs[0] : null;
        return true;
    }

    protected void execute(Event event) {
        ServerTickManager tickManager = Bukkit.getServerTickManager();
        if (this.ticks == null) {
            tickManager.stopStepping();
        } else {
            Timespan timespan = (Timespan)this.ticks.getSingle(event);
            if (timespan != null) {
                tickManager.stepGameIfFrozen((int)timespan.getAs(Timespan.TimePeriod.TICK));
            }
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        if (this.ticks == null) {
            return "stop stepping server";
        }
        return "step server by " + this.ticks.toString(e, d);
    }

    static {
        Skript.registerEffect(EffServerTickStep.class, (String[])new String[]{"step (game|server) [if frozen] [by] %timespan%", "stop stepping (game|server)"});
    }
}

