/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.List;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Click Event Callback")
@Description(value={"Create a click event, that when clicked will run the code in this section.", "\nNOTE: Internally this just makes the player run a special command", "so you will see console messages where a player runs the command \"/paper callback\" in your console.", "\nNOTE: Paper didn't make this command available by default", "so you'll have to give your players the permission `bukkit.command.paper.callback`.", "(As of PaperMC 1.20.1[build-169], the permission is no longer required).", "\n`uses` = The amount of times the player can click this. Defaults to 1. Use `-1` for unlimited uses.", "\n`lifetime` = How long the player has til they can't click it. Defaults to 12 hours."})
@Examples(value={"set {_t} to mini message from \"JOIN US AT SPAWN FOR A SPECIAL EVENT (10 SECONDS REMAINING!)\"", "create callback for {_t} with a duration of 10 seconds:", "\tteleport player to spawn of world \"world\"", "send component {_t} to all players", "", "set {_t} to text component from \"&cDONT CLICK ME\"", "create callback for {_t} with (size of players) uses:", "\tkill player", "\tbroadcast \"&b%player% &eclicked it &cAND DIED&7!!!\"", "send component {_t} to all players", "", "set {_t} to text component from \"Hey you! Click this for a free item.\"", "set {_t2} to text component from \"&e&lONE TIME USE!\"", "create a callback for {_t}:", "\tgive player random item out of available item types", "send components (merge components {_t} and {_t2} with \" \") to players"})
@Since(value={"2.17.0"})
public class SecClickEventCallback
extends Section {
    private Expression<ComponentWrapper> component;
    private Expression<Number> uses;
    private Expression<Timespan> lifeTime;
    private Trigger trigger;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        this.component = exprs[0];
        this.uses = exprs[1];
        this.lifeTime = exprs[2];
        this.trigger = this.loadCode(sectionNode, "callback", new Class[]{ComponentCallbackEvent.class});
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        ComponentWrapper component = (ComponentWrapper)this.component.getSingle(event);
        if (component != null) {
            Timespan lifeTimeSpan;
            Number usesNum;
            int uses = 1;
            if (this.uses != null && (usesNum = (Number)this.uses.getSingle(event)) != null) {
                uses = usesNum.intValue();
            }
            Duration lifeTime = ClickCallback.DEFAULT_LIFETIME;
            if (this.lifeTime != null && (lifeTimeSpan = (Timespan)this.lifeTime.getSingle(event)) != null) {
                lifeTime = Duration.ofMillis(lifeTimeSpan.getAs(Timespan.TimePeriod.MILLISECOND));
            }
            Object localVariables = Variables.copyLocalVariables((Event)event);
            component.setClickEvent(ClickEvent.callback(audience -> {
                Player p;
                Player player = audience instanceof Player ? (p = (Player)audience) : null;
                ComponentCallbackEvent callbackEvent = new ComponentCallbackEvent(player);
                Variables.setLocalVariables((Event)callbackEvent, (Object)localVariables);
                TriggerItem.walk((TriggerItem)this.trigger, (Event)callbackEvent);
                Variables.setLocalVariables((Event)event, (Object)Variables.copyLocalVariables((Event)callbackEvent));
                Variables.removeLocals((Event)callbackEvent);
            }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(uses).lifetime((TemporalAmount)lifeTime).build())));
        }
        return super.walk(event, false);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String uses = this.uses != null ? " with " + this.uses.toString(e, d) + " uses" : "";
        String time = this.lifeTime != null ? " with lifetime of " + this.lifeTime.toString(e, d) : "";
        return "create click event callback for " + this.component.toString(e, d) + uses + time;
    }

    static {
        Skript.registerSection(SecClickEventCallback.class, (String[])new String[]{"create [a] [new] [click event] callback for %textcomponent% [with %-number% use[s]] [[and] with [a] (lifetime|duration) of %-timespan%]"});
    }

    private static class ComponentCallbackEvent
    extends PlayerEvent {
        public ComponentCallbackEvent(Player player) {
            super(player);
        }

        @NotNull
        public HandlerList getHandlers() {
            throw new IllegalStateException("This event should not be called!!!");
        }
    }
}

