/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Player List Name/Header/Footer")
@Description(value={"Represents the player list name/header/footer of a player."})
@Examples(value={"set component player list name of player to mini message from \"<rainbow>%player%\"", "reset component player list name of player", "set {_comp} to component player list name of player", "set component player list header of all players to mini message from \"<rainbow>MY SERVER!!!\""})
@Since(value={"3.5.8"})
public class ExprPlayerListName
extends SimplePropertyExpression<Player, ComponentWrapper> {
    private int type;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.type = parseResult.hasTag("header") ? 1 : (parseResult.hasTag("footer") ? 2 : 0);
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public ComponentWrapper convert(Player player) {
        Component component = switch (this.type) {
            case 1 -> player.playerListHeader();
            case 2 -> player.playerListFooter();
            default -> player.playerListName();
        };
        return ComponentWrapper.fromComponent(component);
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ComponentWrapper.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        TextComponent component;
        Object object;
        if (delta != null && (object = delta[0]) instanceof ComponentWrapper) {
            ComponentWrapper componentWrapper = (ComponentWrapper)object;
            v0 = componentWrapper.getComponent();
        } else {
            v0 = component = null;
        }
        if (component == null && this.type != 0) {
            component = Component.empty();
        }
        block4: for (Player player : (Player[])this.getExpr().getArray(event)) {
            switch (this.type) {
                case 1: {
                    player.sendPlayerListHeader((Component)component);
                    continue block4;
                }
                case 2: {
                    player.sendPlayerListFooter((Component)component);
                    continue block4;
                }
                default: {
                    player.playerListName((Component)component);
                }
            }
        }
    }

    @NotNull
    protected String getPropertyName() {
        String type = this.type == 1 ? "header" : (this.type == 2 ? "footer" : "name");
        return "component player list " + type;
    }

    @NotNull
    public Class<? extends ComponentWrapper> getReturnType() {
        return ComponentWrapper.class;
    }

    static {
        ExprPlayerListName.register(ExprPlayerListName.class, ComponentWrapper.class, (String)"component (player|tab)[ ]list (name|:header|:footer)", (String)"players");
    }
}

