/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import net.kyori.adventure.text.Component;
import org.bukkit.event.Event;
import org.bukkit.event.command.UnknownCommandEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Join/Quit/Kick/Death Message")
@Description(value={"Get/set the join, quit, kick, death, unknown command messages."})
@Examples(value={"on join:", "\tset component join message to mini message from \"<hover:show_entity:player:%uuid of player%><gradient:##FAA401:##5FFA01>%player%<reset><green> joined the game\"", "", "on quit:", "\tset component quit message to mini message from \"<hover:show_entity:player:%uuid of player%><gradient:##FAA401:##5FFA01>%player%<reset><red> left the game\"", "", "on death of player:", "\tif attacker is a player:", "\t\tset {_t} to translate component of attacker's tool", "\t\tset {_m} to mini message from \"<##FA1F01>%victim% <##FAD401>was slain by <##72FA01>%attacker% <##FAD401>using <grey>[<##03FCEA><lang:%{_t}%><grey>]\"", "\t\tset component death message to {_m}"})
@Since(value={"3.4.0"})
public class ExprMessageComponent
extends SimpleExpression<ComponentWrapper> {
    private static final String[] PATTERNS = new String[]{"component join message", "component (quit|kick) message", "component death message", "component unknown command message"};
    private int pattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        ParserInstance parserInstance = ParserInstance.get();
        String errorMessage = "'" + parseResult.expr + "' can only be used in a %s event.";
        if (matchedPattern == 0 && !parserInstance.isCurrentEvent(PlayerJoinEvent.class)) {
            Skript.error((String)String.format(errorMessage, "join"));
            return false;
        }
        if (matchedPattern == 1 && !parserInstance.isCurrentEvent(new Class[]{PlayerQuitEvent.class, PlayerKickEvent.class})) {
            Skript.error((String)String.format(errorMessage, "quit/kick"));
            return false;
        }
        if (matchedPattern == 2 && !parserInstance.isCurrentEvent(EntityDeathEvent.class)) {
            Skript.error((String)String.format(errorMessage, "death"));
            return false;
        }
        if (matchedPattern == 3 && !parserInstance.isCurrentEvent(UnknownCommandEvent.class)) {
            Skript.error((String)String.format(errorMessage, "unknown command"));
            return false;
        }
        return true;
    }

    protected ComponentWrapper @Nullable [] get(Event event) {
        Component component;
        if (this.pattern == 0 && event instanceof PlayerJoinEvent) {
            PlayerJoinEvent joinEvent = (PlayerJoinEvent)event;
            component = joinEvent.joinMessage();
        } else if (this.pattern == 1 && event instanceof PlayerQuitEvent) {
            PlayerQuitEvent quitEvent = (PlayerQuitEvent)event;
            component = quitEvent.quitMessage();
        } else if (this.pattern == 1 && event instanceof PlayerKickEvent) {
            PlayerKickEvent kickEvent = (PlayerKickEvent)event;
            component = kickEvent.leaveMessage();
        } else if (this.pattern == 2 && event instanceof PlayerDeathEvent) {
            PlayerDeathEvent deathEvent = (PlayerDeathEvent)event;
            component = deathEvent.deathMessage();
        } else if (this.pattern == 3 && event instanceof UnknownCommandEvent) {
            UnknownCommandEvent unknownCommandEvent = (UnknownCommandEvent)event;
            component = unknownCommandEvent.message();
        } else {
            return null;
        }
        return new ComponentWrapper[]{ComponentWrapper.fromComponent(component)};
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ComponentWrapper.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        if (delta != null && (object = delta[0]) instanceof ComponentWrapper) {
            ComponentWrapper wrapper = (ComponentWrapper)object;
            Component component = wrapper.getComponent();
            if (this.pattern == 0 && event instanceof PlayerJoinEvent) {
                PlayerJoinEvent joinEvent = (PlayerJoinEvent)event;
                joinEvent.joinMessage(component);
            } else if (this.pattern == 1 && event instanceof PlayerQuitEvent) {
                PlayerQuitEvent quitEvent = (PlayerQuitEvent)event;
                quitEvent.quitMessage(component);
            } else if (this.pattern == 1 && event instanceof PlayerKickEvent) {
                PlayerKickEvent kickEvent = (PlayerKickEvent)event;
                kickEvent.leaveMessage(component);
            } else if (this.pattern == 2 && event instanceof PlayerDeathEvent) {
                PlayerDeathEvent deathEvent = (PlayerDeathEvent)event;
                deathEvent.deathMessage(component);
            } else if (this.pattern == 3 && event instanceof UnknownCommandEvent) {
                UnknownCommandEvent unknownCommandEvent = (UnknownCommandEvent)event;
                unknownCommandEvent.message(component);
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends ComponentWrapper> getReturnType() {
        return ComponentWrapper.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return PATTERNS[this.pattern];
    }

    static {
        Skript.registerExpression(ExprMessageComponent.class, ComponentWrapper.class, (ExpressionType)ExpressionType.SIMPLE, (String[])PATTERNS);
    }
}

