/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Item Lore")
@Description(value={"Get/set the lore of an item using text components."})
@Examples(value={"set component lore of player's tool to mini message from \"<rainbow>OOO RAINBOW LORE\""})
@Since(value={"2.4.0"})
public class ExprItemLore
extends SimpleExpression<ComponentWrapper> {
    private Expression<?> item;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.item = exprs[0];
        return true;
    }

    protected ComponentWrapper @Nullable [] get(Event event) {
        List components = ItemUtils.getValue(this.item.getSingle(event), itemStack -> {
            ArrayList<ComponentWrapper> lores = new ArrayList<ComponentWrapper>();
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta.hasLore()) {
                for (Component component : itemMeta.lore()) {
                    lores.add(ComponentWrapper.fromComponent(component));
                }
            }
            return lores;
        });
        if (components == null) {
            return null;
        }
        return components.toArray(new ComponentWrapper[0]);
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ComponentWrapper[].class, String[].class});
        }
        if (mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ArrayList<Component> lores = new ArrayList<Component>();
        if (delta != null) {
            for (Object object : delta) {
                if (object instanceof ComponentWrapper) {
                    ComponentWrapper component = (ComponentWrapper)object;
                    lores.add(component.getComponent());
                    continue;
                }
                if (!(object instanceof String)) continue;
                String string = (String)object;
                lores.add(ComponentWrapper.fromText(string).getComponent());
            }
        }
        ItemUtils.modifyItems(this.item.getSingle(event), itemStack -> {
            ArrayList components = new ArrayList();
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (mode == Changer.ChangeMode.ADD && itemMeta.hasLore()) {
                components.addAll(itemMeta.lore());
            }
            if (!lores.isEmpty()) {
                components.addAll(lores);
            }
            itemMeta.lore(components.isEmpty() ? null : components);
            itemStack.setItemMeta(itemMeta);
        });
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends ComponentWrapper> getReturnType() {
        return ComponentWrapper.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "component item lore of " + this.item.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprItemLore.class, ComponentWrapper.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] component [item] lore of %itemstack/itemtype/slot%", "%itemstack/itemtype/slot%'[s] component [item] lore"});
    }
}

