/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Json String")
@Description(value={"Get the serialized json string of a text component. Useful in NBT."})
@Examples(value={"set {_m} to mini message from \"<rainbow>HI MOM, I MADE IT ON THE DOCS\"", "set {_j} to serialized json string of {_m}"})
@Since(value={"3.5.0"})
public class ExprComponentToJson
extends SimplePropertyExpression<ComponentWrapper, String> {
    @Nullable
    public String convert(ComponentWrapper wrapper) {
        return wrapper.toJsonString();
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "serialized json string";
    }

    static {
        ExprComponentToJson.register(ExprComponentToJson.class, String.class, (String)"serialized json string", (String)"textcomponents");
    }
}

