/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Children")
@Description(value={"Get the children of a text component. This essentially splits the component up into its parts."})
@Examples(value={"set {_children::*} to component children of {_textcomp}"})
@Since(value={"2.14.0"})
public class ExprComponentChildren
extends SimpleExpression<ComponentWrapper> {
    private Expression<ComponentWrapper> parents;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.parents = exprs[0];
        return true;
    }

    @Nullable
    protected ComponentWrapper[] get(Event event) {
        ArrayList<ComponentWrapper> children = new ArrayList<ComponentWrapper>();
        for (ComponentWrapper parent : (ComponentWrapper[])this.parents.getArray(event)) {
            children.addAll(parent.getChildren());
        }
        return children.toArray(new ComponentWrapper[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends ComponentWrapper> getReturnType() {
        return ComponentWrapper.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "text component children of " + this.parents.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprComponentChildren.class, ComponentWrapper.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[text] component children of %textcomponents%"});
    }
}

