/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import java.util.Objects;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Click Event")
@Description(value={"Create a new click event. Supports run command, suggest command, open link and copy to clipboard."})
@Examples(value={"set {_t} to text component from \"Check out my cool website\"", "add hover event showing \"Clicky clicky to go to spawn!\" to {_t}", "add click event to open url \"https://my.cool.website\" to {_t}", "send component {_t} to player"})
@Since(value={"1.5.0"})
public class ExprClickEvent
extends SimpleExpression<ClickEvent> {
    private static final boolean SUPPORTS_CLIPBOARD = Skript.fieldExists(ClickEvent.Action.class, (String)"COPY_TO_CLIPBOARD");
    private int pattern;
    private Expression<Object> object;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        if (this.pattern == 3 && !SUPPORTS_CLIPBOARD) {
            Skript.error((String)"'click event to copy %string% to clipboard' is not supported on your server version", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.object = exprs[0];
        return true;
    }

    protected ClickEvent @Nullable [] get(Event event) {
        ClickEvent.Action action;
        if (this.object == null) {
            return null;
        }
        Object value = this.object.getSingle(event);
        switch (this.pattern) {
            case 1: {
                action = ClickEvent.Action.SUGGEST_COMMAND;
                break;
            }
            case 2: {
                action = ClickEvent.Action.OPEN_URL;
                break;
            }
            case 3: {
                action = ClickEvent.Action.COPY_TO_CLIPBOARD;
                break;
            }
            case 4: {
                action = ClickEvent.Action.CHANGE_PAGE;
                value = "" + ((Number)Objects.requireNonNull(this.object.getSingle(event))).intValue();
                break;
            }
            default: {
                action = ClickEvent.Action.RUN_COMMAND;
            }
        }
        if (value == null) {
            return null;
        }
        return new ClickEvent[]{ClickEvent.clickEvent((ClickEvent.Action)action, (String)((String)value))};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends ClickEvent> getReturnType() {
        return ClickEvent.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String[] actions = new String[]{"run command", "suggest command", "open url", "copy to clipboard", "change to page"};
        return "click event to " + actions[this.pattern] + " " + this.object.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprClickEvent.class, ClickEvent.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] [new] click event to run command %string%", "[a] [new] click event to suggest command %string%", "[a] [new] click event to open (link|url) %string%", "[a] [new] click event to copy %string% to clipboard", "[a] [new] click event to change to page %number%"});
    }
}

