/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Chest Inventory")
@Description(value={"Create a chest inventory with a component name."})
@Examples(value={"set {_t} to mini message from \"<rainbow>THIS IS A CHEST\"", "set {_i} to chest inventory with component name {_t} with 2 rows", "set slot 1 of {_i} to diamond sword", "open {_i} to player"})
@Since(value={"2.4.0"})
public class ExprChestInventory
extends SimpleExpression<Inventory> {
    private Expression<Number> rows;
    private Expression<ComponentWrapper> name;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.name = exprs[matchedPattern];
        this.rows = exprs[matchedPattern ^ 1];
        return true;
    }

    @Nullable
    protected Inventory[] get(Event event) {
        ComponentWrapper name;
        int defaultRows = InventoryType.CHEST.getDefaultSize() / 9;
        Integer rows = this.rows != null ? (Number)((Number)this.rows.getSingle(event)) : (Number)defaultRows;
        int size = (rows = rows == null ? Integer.valueOf(defaultRows) : rows) * 9;
        if (size % 9 != 0) {
            size = 27;
        }
        if (size < 0) {
            size = 0;
        }
        if (size > 54) {
            size = 54;
        }
        if ((name = (ComponentWrapper)this.name.getSingle(event)) == null) {
            return null;
        }
        return new Inventory[]{Bukkit.createInventory(null, (int)size, (Component)name.getComponent())};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Inventory> getReturnType() {
        return Inventory.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String rows = this.rows != null ? " with " + this.rows.toString(e, d) + " rows" : "";
        String name = " with component name " + this.name.toString(e, d);
        return "chest inventory" + rows + name;
    }

    static {
        Skript.registerExpression(ExprChestInventory.class, Inventory.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a [new]] chest inventory with component name %textcomponent% [with %-number% row[s]]", "[a [new]] chest inventory with %number% row[s] with component name %textcomponent%"});
    }
}

