/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import io.papermc.paper.event.player.AsyncChatEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="TextComponent - Async Chat Format/Message")
@Description(value={"Get/set the chat message from an async chat event as a text component.", "Set the chat format of an async chat event (no getter for this).", "Requires PaperMC!"})
@Examples(value={"on async chat:", "\tset {_m::1} to mini message from \"<gradient:##33FFE6:##33FF68>%player% &7\u00bb \"", "\tset {_m::2} to async chat message", "\tset {_m} to merge components {_m::*}", "\tset async chat format to {_m}"})
@Since(value={"2.18.0"})
public class ExprAsyncChatMessage
extends SimpleExpression<ComponentWrapper> {
    private boolean message;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ParserInstance.get().isCurrentEvent(AsyncChatEvent.class)) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in the Async Chat Event."));
            return false;
        }
        this.message = parseResult.hasTag("message");
        return true;
    }

    @Nullable
    protected ComponentWrapper[] get(Event event) {
        if (!(event instanceof AsyncChatEvent)) {
            return null;
        }
        AsyncChatEvent chatEvent = (AsyncChatEvent)event;
        if (this.message) {
            return new ComponentWrapper[]{ComponentWrapper.fromComponent(chatEvent.message())};
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ComponentWrapper.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        if (delta != null && (object = delta[0]) instanceof ComponentWrapper) {
            ComponentWrapper wrapper = (ComponentWrapper)object;
            if (event instanceof AsyncChatEvent) {
                AsyncChatEvent chatEvent = (AsyncChatEvent)event;
                if (this.message) {
                    chatEvent.message(wrapper.getComponent());
                } else {
                    chatEvent.renderer((source, sourceDisplayName, message, viewer) -> wrapper.getComponent());
                }
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends ComponentWrapper> getReturnType() {
        return ComponentWrapper.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String message = this.message ? "message" : "format";
        return "async chat " + message;
    }

    static {
        Skript.registerExpression(ExprAsyncChatMessage.class, ComponentWrapper.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"async chat (format|:message)"});
    }
}

