/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.text.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="TextComponent - Replace Text")
@Description(value={"Replace a string with another string or text component in a text component. Supports regex patterns.", "NOTE: If you notice sometimes your symbols aren't replace, this could be a regex pattern issue and you may need to escape characters.", "ex: `:(` -> `:\\(` and `[` -> `\\[`"})
@Examples(value={"component replace \"puppy\" with \"***\" in {_comp}", "component replace \"\\d+\" with \"0\" in {_comp}", "component replace \":\\(\" with \"sad\" in {_comp}"})
@Since(value={"2.18.0"})
public class EffComponentReplace
extends Effect {
    private Expression<String> toReplace;
    private Expression<Object> replacement;
    private Expression<ComponentWrapper> components;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.toReplace = exprs[0];
        this.replacement = exprs[1];
        this.components = exprs[2];
        return true;
    }

    protected void execute(Event event) {
        ComponentWrapper w;
        String s;
        Object replacement = this.replacement.getSingle(event);
        String replacementString = replacement instanceof String ? (s = (String)replacement) : null;
        ComponentWrapper replacementComp = replacement instanceof ComponentWrapper ? (w = (ComponentWrapper)replacement) : null;
        for (ComponentWrapper component : (ComponentWrapper[])this.components.getArray(event)) {
            for (String s2 : (String[])this.toReplace.getArray(event)) {
                if (replacementString != null) {
                    component.replace(s2, replacementString);
                    continue;
                }
                if (replacementComp == null) continue;
                component.replace(s2, replacementComp);
            }
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String toReplace = this.toReplace.toString(e, d);
        String replace = this.replacement.toString(e, d);
        String comp = this.components.toString(e, d);
        return "component replace " + toReplace + " with " + replace + " in " + comp;
    }

    static {
        Skript.registerEffect(EffComponentReplace.class, (String[])new String[]{"component replace %strings% with %string/textcomponent% in %textcomponents%"});
    }
}

