/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.switchcase.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.CondCompare;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SectionExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionSection;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.ReturnHandler;
import ch.njol.skript.lang.ReturnableTrigger;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.SectionSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.elements.switchcase.events.SwitchBaseEvent;
import com.shanebeestudios.skbee.elements.switchcase.events.SwitchReturnEvent;
import com.shanebeestudios.skbee.elements.switchcase.sections.SecExprSwitchReturn;
import com.shanebeestudios.skbee.elements.switchcase.sections.SecSwitch;
import java.util.List;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.comparator.Comparators;
import org.skriptlang.skript.lang.comparator.Relation;

@Name(value="SwitchCase - Case")
@Description(value={"In a switch section/expression, you can manage different actions based on the case matching the switched value.", "Multiple objects are supported in cases.", "Default will run if all other cases fail to match. Default must go last or all cases after it will be ignored."})
@Examples(value={"on break:", "\tswitch event-block:", "\t\tcase dirt:", "\t\t\tgive player a stick named \"Dirt\"", "\t\tcase stone:", "\t\t\tgive player an apple named \"Stone\"", "\t\tcase grass block:", "\t\t\tgive player an iron ingot named \"Iron Ingot\"", "\t\tdefault:", "\t\t\tkill player", "", "on damage of a mob by a player:", "\tswitch type of victim:", "\t\tcase zombie, husk, a drowned:", "\t\t\tspawn 3 baby zombies at victim", "\t\tcase skeleton, stray:", "\t\t\tspawn a skeleton horse at victim:", "\t\t\t\tset {_h} to entity", "\t\t\tspawn a skeleton at victim:", "\t\t\t\tset {_s} to entity", "\t\t\tmake {_s} ride {_h}", "\t\tcase sheep, cow, chicken, pig:", "\t\t\tkill attacker", "\t\tdefault:", "\t\t\tgive attacker a diamond"})
@Since(value={"3.8.0"})
public class SecCase
extends Section
implements ReturnHandler<Object> {
    private Expression<Object> caseObject;
    private boolean defaultCase;
    private ReturnableTrigger<?> caseSection;
    private Object returnObject;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        SecSwitch switchSection = null;
        Expression<?> switchObject = null;
        Object[] objectArray = this.getParser().getCurrentStructure();
        if (objectArray instanceof SectionSkriptEvent) {
            SectionSkriptEvent skriptEvent = (SectionSkriptEvent)objectArray;
            Section section = skriptEvent.getSection();
            if (section instanceof SecSwitch) {
                SecSwitch secSwitch;
                switchSection = secSwitch = (SecSwitch)section;
                switchObject = secSwitch.getSwitchedObjectExpression();
            } else {
                ExpressionSection expressionSection;
                SectionExpression sectionExpression;
                section = skriptEvent.getSection();
                if (section instanceof ExpressionSection && (sectionExpression = (expressionSection = (ExpressionSection)section).getAsExpression()) instanceof SecExprSwitchReturn) {
                    SecExprSwitchReturn secExprSwitchReturn = (SecExprSwitchReturn)sectionExpression;
                    switchSection = expressionSection;
                    switchObject = secExprSwitchReturn.getSwitchedObjectExpression();
                }
            }
        }
        if (switchSection == null) {
            Skript.error((String)"Cases can only be used in a switch section/expression.");
            return false;
        }
        if (matchedPattern == 1) {
            this.defaultCase = true;
        } else {
            this.caseObject = LiteralUtils.defendExpression(exprs[0]);
            if (switchObject != null && (objectArray = this.caseObject) instanceof Literal) {
                Literal literal = (Literal)objectArray;
                for (Object lit : literal.getArray()) {
                    Class switchReturnType = switchObject.getReturnType();
                    if (SecCase.canCompare(switchReturnType, lit.getClass())) continue;
                    Skript.error((String)("Can't compare " + CondCompare.f(switchObject) + " with " + CondCompare.f((Expression)literal)));
                    return false;
                }
            }
        }
        if (sectionNode != null) {
            this.caseSection = this.loadReturnableSectionCode(sectionNode, "case section", this.getParser().getCurrentEvents());
        }
        return this.defaultCase || LiteralUtils.canInitSafely((Expression[])new Expression[]{this.caseObject});
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        if (event instanceof SwitchBaseEvent) {
            SwitchBaseEvent switchEvent = (SwitchBaseEvent)event;
            if (this.defaultCase || SecCase.compare(this.caseObject.getArray(event), switchEvent.getSwitchedObject())) {
                Trigger.walk(this.caseSection, (Event)switchEvent.getParentEvent());
                if (event instanceof SwitchReturnEvent) {
                    SwitchReturnEvent switchReturnEvent = (SwitchReturnEvent)event;
                    if (this.returnObject != null) {
                        switchReturnEvent.setReturnedObject(this.returnObject);
                    }
                }
                return null;
            }
            if (this.getActualNext() != null) {
                return super.walk(event, false);
            }
        }
        return null;
    }

    public String toString(Event e, boolean d) {
        if (this.defaultCase) {
            return "default case";
        }
        return "case " + this.caseObject.toString(e, d);
    }

    public static boolean canCompare(Class<?> c1, Class<?> c2) {
        if (c1 == Object.class || c2 == Object.class) {
            return true;
        }
        return Comparators.comparatorExists(c1, c2);
    }

    public static boolean compare(Object[] comparables, Object source) {
        if (comparables == null || source == null) {
            return false;
        }
        for (Object comparable : comparables) {
            if (!Comparators.comparatorExists(comparable.getClass(), source.getClass()) || Comparators.compare((Object)source, (Object)comparable) != Relation.EQUAL) continue;
            return true;
        }
        return comparables.equals(source);
    }

    public void returnValues(Event event, Expression<?> value) {
        this.returnObject = value.getSingle(event);
    }

    public boolean isSingleReturnValue() {
        return true;
    }

    @Nullable
    public Class<?> returnValueType() {
        return Object.class;
    }

    static {
        Skript.registerSection(SecCase.class, (String[])new String[]{"case %objects%", "(default [case]|case default)"});
    }
}

