/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.structure.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.structure.StructureWrapper;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

@Name(value="Structure - Properties")
@Description(value={"Represents different properties of a structure, including mirroring, rotation, inclusion of entities and integrity.", "These properties are only used for placing the structure in a world, they are NOT saved to the structure file.", "Mirror determines which way the structure mirrors, either 'none', 'front back' or 'left right'.", "Rotation determines which way the structure is rotated, either 'none', 'clockwise 90', 'clockwise 180' or 'counterclockwise 90'.", "Integrity determines how damaged the building should look by randomly skipping blocks to place. This value can range from 0 to 1.", "With 0 removing all blocks and 1 spawning the structure in pristine condition.", "Include entities determines if saved entities should be spawned into the structure (true by default).", "Size returns a vector offset from the starting point of the structure. This cannot be changed.", "\nNOTE: `reset` will reset the value back to default. (added in v-2.7.2)", "Requires MC 1.17.1+"})
@Examples(value={"set structure rotation of {_s} to clockwise 90", "set {_r} to structure rotation of {_s}", "set {_v} to structure size of {_s}", "set structure include entities of {_s} to false", "set structure integrity of {_s} to 0.75", "reset structure rotation of {_s}", "reset structure integrity of {_s}"})
@Since(value={"1.12.0"})
public class ExprStructureProperties
extends PropertyExpression<StructureWrapper, Object> {
    private int pattern;
    private Expression<StructureWrapper> structures;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = matchedPattern;
        this.structures = exprs[0];
        this.setExpr(this.structures);
        return true;
    }

    protected Object[] get(Event event, StructureWrapper[] source) {
        return this.get(source, structure -> switch (this.pattern) {
            case 0 -> structure.getMirror();
            case 1 -> structure.getRotation();
            case 2 -> Float.valueOf(structure.getIntegrity());
            case 3 -> Boolean.valueOf(structure.isIncludeEntities());
            case 4 -> structure.getSize();
            default -> null;
        });
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            Class[] classArray;
            switch (this.pattern) {
                case 0: {
                    Class[] classArray2 = new Class[1];
                    classArray = classArray2;
                    classArray2[0] = Mirror.class;
                    break;
                }
                case 1: {
                    Class[] classArray3 = new Class[1];
                    classArray = classArray3;
                    classArray3[0] = StructureRotation.class;
                    break;
                }
                case 2: {
                    Class[] classArray4 = new Class[1];
                    classArray = classArray4;
                    classArray4[0] = Number.class;
                    break;
                }
                case 3: {
                    Class[] classArray5 = new Class[1];
                    classArray = classArray5;
                    classArray5[0] = Boolean.class;
                    break;
                }
                default: {
                    classArray = null;
                }
            }
            return classArray;
        }
        return super.acceptChange(mode);
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        boolean reset;
        boolean bl = reset = mode == Changer.ChangeMode.RESET;
        if (mode == Changer.ChangeMode.SET || reset) {
            block6: for (StructureWrapper structure : (StructureWrapper[])this.getExpr().getArray(event)) {
                switch (this.pattern) {
                    case 0: {
                        structure.setMirror(reset ? Mirror.NONE : (Mirror)delta[0]);
                        continue block6;
                    }
                    case 1: {
                        structure.setRotation(reset ? StructureRotation.NONE : (StructureRotation)delta[0]);
                        continue block6;
                    }
                    case 2: {
                        float v;
                        Integer num = reset ? (Number)1 : (Number)((Number)delta[0]);
                        float integrity = 1.0f;
                        if (num != null && ((v = ((Number)num).floatValue()) >= 0.0f || v <= 1.0f)) {
                            integrity = v;
                        }
                        structure.setIntegrity(integrity);
                        continue block6;
                    }
                    case 3: {
                        structure.setIncludeEntities(reset || (Boolean)delta[0] != false);
                    }
                }
            }
        }
    }

    public Class<?> getReturnType() {
        return switch (this.pattern) {
            case 0 -> Mirror.class;
            case 1 -> StructureRotation.class;
            case 2 -> Number.class;
            case 3 -> Boolean.class;
            case 4 -> Vector.class;
            default -> null;
        };
    }

    public String toString(@Nullable Event e, boolean d) {
        String property = switch (this.pattern) {
            case 0 -> "mirror";
            case 1 -> "rotation";
            case 2 -> "integrity";
            case 3 -> "include entities";
            case 4 -> "size";
            default -> "";
        };
        return String.format("%s property of structure %s", property, this.structures.toString(e, d));
    }

    static {
        Skript.registerExpression(ExprStructureProperties.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"structure mirror of %structures%", "structure rotation of %structures%", "structure integrity of %structures%", "structure include entities of %structures%", "structure size of %structures%"});
    }
}

