/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.structure.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.structure.StructureManager;
import com.shanebeestudios.skbee.api.structure.StructureWrapper;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Structure - Object")
@Description(value={"Create a new, empty structure or load a structure from file. ", "If the file you have specified is not available, it will be created upon saving.", "Structures without a namespace (ex: \"tree\") will default to the \"minecraft\" namespace and load from/save to \"(main world folder)/generated/minecraft/structures/\".", "Structures with a namespace (ex:\"myname:house\") will load from/save to \"(main world folder)/generated/myname/structures/\".", "To create folders, simply add a slash in your name, ex: \"buildings/house\".", "Changes made to structures will not automatically be saved to file, you will need to use the save structure effect.", "Requires MC 1.17.1+"})
@Examples(value={"set {_s} to structure with id \"my-server:houses/house1\"", "set {_s} to structure with id \"my-house\"", "set {_s} to structure with id \"minecraft:village/taiga/houses/taiga_cartographer_house_1\"", "set {_s::*} to structures with id \"house1\" and \"house2\""})
@Since(value={"1.12.0"})
public class ExprStructureObject
extends SimpleExpression<StructureWrapper> {
    private static final StructureManager STRUCTURE_MANAGER = SkBee.getPlugin().getStructureManager();
    private Expression<String> fileString;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.fileString = exprs[0];
        return true;
    }

    @Nullable
    protected StructureWrapper[] get(Event event) {
        ArrayList<StructureWrapper> structures = new ArrayList<StructureWrapper>();
        for (String file : (String[])this.fileString.getAll(event)) {
            assert (STRUCTURE_MANAGER != null);
            StructureWrapper structure = STRUCTURE_MANAGER.getStructure(file);
            if (structure == null) continue;
            structures.add(structure);
        }
        return structures.toArray(new StructureWrapper[0]);
    }

    public boolean isSingle() {
        return this.fileString.isSingle();
    }

    public Class<? extends StructureWrapper> getReturnType() {
        return StructureWrapper.class;
    }

    public String toString(Event e, boolean d) {
        return "structure[s] with id " + this.fileString.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprStructureObject.class, StructureWrapper.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"structure[s] (named|with id|with key) %strings%"});
    }
}

