/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.reflection.ChatReflection;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Team - Prefix/Suffix")
@Description(value={"Get/set/delete the prefix/suffix of a team."})
@Examples(value={"set team prefix of {_team} to \"[OWNER]\"", "set team suffix of {_team} to \"[GOLD]\"", "set {_pre} to team prefix of {_team}", "set team prefix of team of player to \"[BestTeam]\""})
@Since(value={"1.16.0"})
public class ExprTeamPrefix
extends SimplePropertyExpression<Team, String> {
    private int pattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.mark;
        this.setExpr(exprs[0]);
        return true;
    }

    @Nullable
    public String convert(Team team) {
        String value = this.pattern == 0 ? team.getPrefix() : team.getSuffix();
        if (value.isEmpty()) {
            return null;
        }
        return value;
    }

    @Nullable
    public Class<?>[] acceptChange(@NotNull Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.DELETE -> (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Team[] teams = (Team[])this.getExpr().getArray(event);
        String name = mode == Changer.ChangeMode.SET ? (String)delta[0] : null;
        for (Team team : teams) {
            this.setTeamDetail(team, name, this.pattern == 0);
        }
    }

    private void setTeamDetail(Team team, String detail, boolean prefix) {
        if (Util.IS_RUNNING_MC_1_20_1) {
            if (prefix) {
                team.setPrefix(detail);
            } else {
                team.setSuffix(detail);
            }
        } else if (prefix) {
            ChatReflection.setTeamPrefix(team, detail);
        } else {
            ChatReflection.setTeamSuffix(team, detail);
        }
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    protected String getPropertyName() {
        return "team " + (this.pattern == 0 ? "prefix" : "suffix");
    }

    static {
        ExprTeamPrefix.register(ExprTeamPrefix.class, String.class, (String)"team (prefix|1:suffix)", (String)"team");
    }
}

