/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Team - Name")
@Description(value={"Represents the name and display name of a team.", "\nNOTE: Display name can be set, name cannot be set."})
@Examples(value={"set team display name of {_team} to \"The Warriors\"", "set team display name of team of player to \"The Rednecks\"", "set team display name of team named \"blue-team\" to \"Blue Team\"", "set {_name} to team name of team of player"})
@Since(value={"2.10.0"})
public class ExprTeamName
extends SimplePropertyExpression<Team, String> {
    private boolean display;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.display = parseResult.hasTag("display");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public String convert(Team team) {
        return this.display ? team.getDisplayName() : team.getName();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.display && mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Team[] teamArray;
        if (!this.display) {
            return;
        }
        if (delta != null && (teamArray = delta[0]) instanceof String) {
            String name = (String)teamArray;
            for (Team team : (Team[])this.getExpr().getArray(event)) {
                team.setDisplayName(name);
            }
        }
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    protected String getPropertyName() {
        return this.display ? "team display name" : "team name";
    }

    static {
        ExprTeamName.register(ExprTeamName.class, String.class, (String)"team [:display] name", (String)"teams");
    }
}

