/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.SkriptColor;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.ChatUtil;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Team - Color")
@Description(value={"Get/set the color of a team."})
@Examples(value={"set team color of {_team} to blue", "set team color of team of player to red"})
@Since(value={"1.16.0"})
public class ExprTeamColor
extends SimplePropertyExpression<Team, SkriptColor> {
    @Nullable
    public SkriptColor convert(Team team) {
        return ChatUtil.getSkriptColorByBungee(team.getColor().asBungee());
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[]{Color.class});
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        SkriptColor skriptColor;
        Object object;
        SkriptColor color = delta != null && (object = delta[0]) instanceof SkriptColor ? (skriptColor = (SkriptColor)object) : null;
        for (Team team : (Team[])this.getExpr().getArray(event)) {
            if (color != null) {
                team.setColor(color.asChatColor());
                continue;
            }
            team.setColor(ChatColor.WHITE);
        }
    }

    @NotNull
    public Class<? extends SkriptColor> getReturnType() {
        return SkriptColor.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "team color";
    }

    static {
        ExprTeamColor.register(ExprTeamColor.class, SkriptColor.class, (String)"team color", (String)"teams");
    }
}

