/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.scoreboard.TeamUtils;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Team - From Entity")
@Description(value={"Get an instance of a team from an entity.", "You have the option to get a team from a specific scoreboard (defaults to the main scoreboard).", "Teams off the main scoreboard cannot be serialized/saved to variables (This is because custom scoreboards aren't persistent)."})
@Examples(value={"set {_team} to team of player", "set {_team} to team of player from {-teams::groups}"})
@Since(value={"1.16.0"})
public class ExprTeam
extends SimpleExpression<Team> {
    private Expression<Entity> entities;
    private Expression<Scoreboard> scoreboard;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.scoreboard = exprs[1];
        return true;
    }

    protected Team @Nullable [] get(Event event) {
        Scoreboard scoreboard = (Scoreboard)this.scoreboard.getSingle(event);
        if (scoreboard == null) {
            return null;
        }
        return (Team[])this.entities.stream(event).map(entity -> TeamUtils.getTeam(entity, scoreboard)).toArray(Team[]::new);
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Team.class});
        }
        return super.acceptChange(mode);
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            Team deltaTeam;
            Object object;
            Team team;
            Team team2 = team = delta != null && (object = delta[0]) instanceof Team ? (deltaTeam = (Team)object) : null;
            if (team == null || this.entities == null) {
                return;
            }
            Entity entity = (Entity)this.entities.getSingle(event);
            if (entity == null) {
                return;
            }
            team.addEntity(entity);
            return;
        }
        super.change(event, delta, mode);
    }

    public boolean isSingle() {
        return this.entities.isSingle();
    }

    @NotNull
    public Class<? extends Team> getReturnType() {
        return Team.class;
    }

    @NotNull
    public String toString(Event event, boolean debug) {
        SyntaxStringBuilder builder = new SyntaxStringBuilder(event, debug);
        builder.append(new Object[]{"team of", this.entities});
        if (!this.scoreboard.isDefault()) {
            builder.append(new Object[]{"from scoreboard", this.scoreboard});
        }
        return builder.toString();
    }

    static {
        Skript.registerExpression(ExprTeam.class, Team.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"team of %entity% [(of|from) %scoreboard%]"});
    }
}

