/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import java.util.ArrayList;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Scoreboard - Objective Score")
@Description(value={"Get/Set the score of an entity/string for an objective.", "If the score has never been set, it'll return nothing."})
@Examples(value={"set score of player for {_objective} to 10", "set score of \"le_test\" for {_objective} to 25", "set {_score} to score of target entity for {_objective}", "set {_score} to score of \"le_test\" for {_objective}"})
@Since(value={"2.6.0"})
public class ExprObjScore
extends SimpleExpression<Number> {
    private Expression<Objective> objective;
    private Expression<?> entries;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entries = exprs[0];
        this.objective = exprs[1];
        return true;
    }

    @Nullable
    protected Number[] get(Event event) {
        ArrayList<Number> scores = new ArrayList<Number>();
        Objective objective = (Objective)this.objective.getSingle(event);
        if (objective != null) {
            for (Object entry : this.entries.getArray(event)) {
                scores.add(this.getScore(objective, entry));
            }
        }
        return scores.toArray(new Number[0]);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE, Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
            case Changer.ChangeMode.REMOVE_ALL, Changer.ChangeMode.RESET, Changer.ChangeMode.DELETE -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Objective objective = (Objective)this.objective.getSingle(event);
        if (objective == null) {
            return;
        }
        Object object = delta[0];
        if (object instanceof Number) {
            Number number = (Number)object;
            int changeValue = number.intValue();
            block5: for (Object entry : this.entries.getArray(event)) {
                Number score = this.getScore(objective, entry);
                int oldScore = score != null ? score.intValue() : 0;
                switch (mode) {
                    case SET: {
                        this.setScore(objective, entry, changeValue);
                        continue block5;
                    }
                    case ADD: {
                        this.setScore(objective, entry, oldScore + changeValue);
                        continue block5;
                    }
                    case REMOVE: {
                        this.setScore(objective, entry, oldScore - changeValue);
                    }
                }
            }
        }
    }

    private Number getScore(Objective objective, Object entry) {
        Score score;
        String stringEntiry = null;
        if (entry instanceof Player) {
            Player player = (Player)entry;
            stringEntiry = player.getName();
        } else if (entry instanceof Entity) {
            Entity entity = (Entity)entry;
            stringEntiry = entity.getUniqueId().toString();
        } else if (entry instanceof String) {
            String string;
            stringEntiry = string = (String)entry;
        }
        if (stringEntiry != null && (score = objective.getScore(stringEntiry)).isScoreSet()) {
            return score.getScore();
        }
        return null;
    }

    private void setScore(Objective objective, Object entry, int score) {
        String stringEntiry = null;
        if (entry instanceof Player) {
            Player player = (Player)entry;
            stringEntiry = player.getName();
        } else if (entry instanceof Entity) {
            Entity entity = (Entity)entry;
            stringEntiry = entity.getUniqueId().toString();
        } else if (entry instanceof String) {
            String string;
            stringEntiry = string = (String)entry;
        }
        if (stringEntiry != null) {
            if (objective.isModifiable()) {
                objective.getScore(stringEntiry).setScore(score);
            } else {
                this.error("Objective '" + objective.getName() + "' has no modifiable score");
            }
        }
    }

    public boolean isSingle() {
        return this.entries.isSingle();
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "score of " + this.entries.toString(e, d) + " for " + this.objective.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprObjScore.class, Number.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"score of %entities/strings% for %objective%"});
    }
}

