/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Objective;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Scoreboard - Objective Name")
@Description(value={"Represents the name/display name of an objective.", "- `name` = The name/id given to the objective (Cannot be changed).", "- `display name` = The name the players will see [as a string] (Can be changed).", "- `component display name` = The name the players will see [as a text component] (Can be changed)."})
@Examples(value={"set objective display name of {_objective} to \"le-objective\""})
@Since(value={"2.6.0"})
public class ExprObjName
extends SimpleExpression<Object> {
    private static final boolean HAS_COMP = SkBee.getPlugin().getAddonLoader().isTextComponentEnabled();
    private static final Class<?>[] RETURN_CLASSES = HAS_COMP ? (Class[])CollectionUtils.array((Object[])new Class[]{String.class, ComponentWrapper.class}) : (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
    private Expression<Objective> objective;
    private boolean display;
    private boolean component;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.objective = exprs[0];
        this.display = matchedPattern == 1;
        this.component = parseResult.hasTag("component");
        return true;
    }

    @Nullable
    protected Object[] get(Event event) {
        Objective objective = (Objective)this.objective.getSingle(event);
        if (objective == null) {
            return null;
        }
        if (this.display) {
            if (this.component) {
                return new ComponentWrapper[]{ComponentWrapper.fromComponent(objective.displayName())};
            }
            return new String[]{objective.getDisplayName()};
        }
        return new Object[]{objective.getName()};
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            if (!this.display) {
                Skript.error((String)"Cannot change the name of an objective.");
                return null;
            }
            return RETURN_CLASSES;
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Objective objective = (Objective)this.objective.getSingle(event);
        Object object = delta[0];
        if (object instanceof String) {
            String name = (String)object;
            if (mode == Changer.ChangeMode.SET && objective != null) {
                objective.setDisplayName(name);
            }
        }
        if (delta != null) {
            Object object2 = delta[0];
            if (object2 instanceof String) {
                String string = (String)object2;
                objective.setDisplayName(string);
            } else if (HAS_COMP && (object2 = delta[0]) instanceof ComponentWrapper) {
                ComponentWrapper cw = (ComponentWrapper)object2;
                objective.displayName(cw.getComponent());
            }
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<?> getReturnType() {
        return this.component ? ComponentWrapper.class : String.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String type = this.display ? "display name" : "name";
        return "objective " + type + " of " + this.objective.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprObjName.class, Object.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"objective (name|id) of %objective%", HAS_COMP ? "objective [:component] display name of %objective%" : "objective display name of %objective%"});
    }
}

