/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Scoreboard - Objective Get")
@Description(value={"Get an already registered objective.", "Optionally can input a scoreboard (will default to main scoreboard)."})
@Examples(value={"set {_obj} to objective with id \"le-objective\"", "set {_obj} to objective with id \"my_objective\" from player's scoreboard"})
@Since(value={"2.6.0"})
public class ExprObjGet
extends SimpleExpression<Objective> {
    private Expression<String> id;
    private Expression<Scoreboard> scoreboard;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.id = exprs[0];
        this.scoreboard = exprs[1];
        return true;
    }

    @Nullable
    protected Objective[] get(Event event) {
        Scoreboard scoreboard = (Scoreboard)this.scoreboard.getSingle(event);
        if (scoreboard == null) {
            return null;
        }
        String id = (String)this.id.getSingle(event);
        if (id != null) {
            return new Objective[]{scoreboard.getObjective(id)};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Objective> getReturnType() {
        return Objective.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String board = this.scoreboard != null ? " from scoreboard " + this.scoreboard.toString(e, true) : "";
        return "objective from id " + this.id.toString(e, d) + board;
    }

    static {
        Skript.registerExpression(ExprObjGet.class, Objective.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"objective (with id|from [id]) %string% [(from|of) %scoreboard%]"});
    }
}

