/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import java.util.ArrayList;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.Nullable;

@Name(value="Scoreboard - Objective from DisplaySlot")
@Description(value={"Get/clear objectives from specific display slots of scoreboards."})
@Examples(value={"set {_obj} to objectives from slot sidebar of scoreboard of player", "set {_obj} to objectives from slot player list", "set {_obj} to objectives from slot below name from main scoreboard", "clear objectives from slot player list of main scoreboard"})
@Since(value={"3.9.0"})
public class ExprObjFromDisplaySlot
extends SimpleExpression<Objective> {
    private Expression<DisplaySlot> displaySlots;
    private Expression<Scoreboard> scoreboards;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.displaySlots = exprs[0];
        this.scoreboards = exprs[1];
        return true;
    }

    protected Objective @Nullable [] get(Event event) {
        ArrayList<Objective> objectives = new ArrayList<Objective>();
        for (Scoreboard scoreboard : (Scoreboard[])this.scoreboards.getArray(event)) {
            for (DisplaySlot displaySlot : (DisplaySlot[])this.displaySlots.getArray(event)) {
                Objective objective = scoreboard.getObjective(displaySlot);
                if (objective == null) continue;
                objectives.add(objective);
            }
        }
        return objectives.toArray(new Objective[0]);
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        for (Scoreboard scoreboard : (Scoreboard[])this.scoreboards.getArray(event)) {
            for (DisplaySlot displaySlot : (DisplaySlot[])this.displaySlots.getArray(event)) {
                scoreboard.clearSlot(displaySlot);
            }
        }
    }

    public boolean isSingle() {
        return this.scoreboards.isSingle() && this.displaySlots.isSingle();
    }

    public Class<? extends Objective> getReturnType() {
        return Objective.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return new SyntaxStringBuilder(event, debug).append(new Object[]{"objectives from slot", this.displaySlots}).append(new Object[]{"of", this.scoreboards}).toString();
    }

    static {
        Skript.registerExpression(ExprObjFromDisplaySlot.class, Objective.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"objective[s] (from|by) [display[ ]]slot[s] %displayslots% [(of|from) %scoreboards%]"});
    }
}

