/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import java.util.ArrayList;
import java.util.Set;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.Nullable;

@Name(value="Scoreboard - Objective from Criteria")
@Description(value={"Get objectives from specific criterias of scoreboards."})
public class ExprObjFromCriteria
extends SimpleExpression<Objective> {
    private Expression<Criteria> criterias;
    private Expression<Scoreboard> scoreboards;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.criterias = exprs[0];
        this.scoreboards = exprs[1];
        return true;
    }

    protected Objective @Nullable [] get(Event event) {
        ArrayList objectives = new ArrayList();
        for (Scoreboard scoreboard : (Scoreboard[])this.scoreboards.getArray(event)) {
            for (Criteria criteria : (Criteria[])this.criterias.getArray(event)) {
                Set objectivesByCriteria = scoreboard.getObjectivesByCriteria(criteria);
                objectives.addAll(objectivesByCriteria);
            }
        }
        return objectives.toArray(new Objective[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Objective> getReturnType() {
        return Objective.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return new SyntaxStringBuilder(event, debug).append(new Object[]{"objectives by criteria", this.criterias}).append(new Object[]{"from", this.scoreboards}).toString();
    }

    static {
        Skript.registerExpression(ExprObjFromCriteria.class, Objective.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"objectives (from|by) criteria[s] %criterias% [(of|from) %scoreboards%]"});
    }
}

