/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import java.util.Objects;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Scoreboard - Objective Create")
@Description(value={"Create an objective.", "- `id` = The id used to keep track of your objective.", "- `criteria` = Uses a criteria object. If using an older server version, this will just be a string.", "- `named` = The display name of this objective.", "- `for scoreboard` = Optionally use a specific scoreboard (will default to the main scoreboard).", "- `render type` = How this objective will render, hearts or integer.", "- `display slot` = Where this objective will render."})
@Examples(value={"set {_obj} to objective with id \"le-health\" with criteria {_c} named \"&bLe &cHealth\" with render type hearts in display slot player_list", "set {_obj} to objective with id \"my_objective\" with criteria \"dummy\" named \"OUR GOALS!\" for scoreboard of player"})
@Since(value={"2.6.0"})
public class ExprObjCreate
extends SimpleExpression<Objective> {
    private static final boolean HAS_CRITERIA_CLASS = Skript.classExists((String)"org.bukkit.scoreboard.Criteria");
    private Expression<String> id;
    private Expression<?> criteria;
    private Expression<String> displayName;
    private Expression<Scoreboard> scoreboard;
    private Expression<RenderType> renderType;
    private Expression<DisplaySlot> displaySlot;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.id = exprs[0];
        this.criteria = exprs[1];
        this.displayName = exprs[2];
        this.scoreboard = exprs[3];
        this.renderType = exprs[4];
        this.displaySlot = exprs[5];
        return true;
    }

    protected Objective @Nullable [] get(Event event) {
        Scoreboard scoreboard = (Scoreboard)this.scoreboard.getSingle(event);
        if (scoreboard == null) {
            return null;
        }
        String id = (String)this.id.getSingle(event);
        String displayName = (String)this.displayName.getSingle(event);
        RenderType renderType = this.renderType == null ? null : (RenderType)this.renderType.getSingle(event);
        if (id == null) {
            return null;
        }
        Objective objective = scoreboard.getObjective(id);
        if (objective == null) {
            DisplaySlot displaySlot;
            if (HAS_CRITERIA_CLASS) {
                Object object = this.criteria.getSingle(event);
                if (object instanceof Criteria) {
                    Criteria c = (Criteria)object;
                    criteria = c;
                } else if (object instanceof String) {
                    String string = (String)object;
                    criteria = Criteria.create((String)string);
                } else {
                    return null;
                }
                if (displayName != null) {
                    objective = scoreboard.registerNewObjective(id, (Criteria)criteria, displayName, Objects.requireNonNullElseGet(renderType, () -> ((Criteria)criteria).getDefaultRenderType()));
                }
            } else {
                criteria = (String)this.criteria.getSingle(event);
                if (displayName != null && criteria != null) {
                    objective = renderType != null ? scoreboard.registerNewObjective(id, criteria, displayName, renderType) : scoreboard.registerNewObjective(id, criteria, displayName);
                }
            }
            if (this.displaySlot != null && (displaySlot = (DisplaySlot)this.displaySlot.getSingle(event)) != null && objective != null) {
                objective.setDisplaySlot(displaySlot);
            }
        }
        return new Objective[]{objective};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Objective> getReturnType() {
        return Objective.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String render = this.renderType != null ? " with render type " + this.renderType.toString(e, d) : "";
        String display = this.displaySlot != null ? " in display slot " + this.displaySlot.toString(e, d) : "";
        return "objective with id " + this.id.toString(e, d) + " with criteria " + this.criteria.toString(e, d) + " named " + this.displayName.toString(e, d) + render + display;
    }

    static {
        String pattern = HAS_CRITERIA_CLASS ? "criteria/string" : "string";
        Skript.registerExpression(ExprObjCreate.class, Objective.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"objective with id %string% with [criteria] %" + pattern + "% named %string% [(for|of|from) %scoreboard%] [with render[ ]type %-rendertype%] [(with|in) [display[ ]slot] %-displayslot%]"});
    }
}

