/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.scoreboard.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxStringBuilder;
import ch.njol.util.Kleenean;
import java.util.function.Predicate;
import org.bukkit.event.Event;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.Objective;

@Name(value="Scoreboard - Objective/Critera Modifiable")
@Description(value={"Check if an objective/criteria has modifiable scores.", "Some criteria such as 'health' cannot be modified.", "See [**Criteria**](https://minecraft.wiki/w/Scoreboard#Criteria) on McWiki for more info."})
@Examples(value={"if the scores of {_objective} are modifiable:", "if the scores of criteria with id \"some_criteria\" are modifiable:"})
@Since(value={"3.8.0"})
public class CondObjModifiable
extends Condition {
    private Expression<?> objects;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.objects = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        return this.objects.check(event, (Predicate)new Predicate<Object>(){

            @Override
            public boolean test(Object object) {
                if (object instanceof Objective) {
                    Objective objective = (Objective)object;
                    return objective.isModifiable();
                }
                if (object instanceof Criteria) {
                    Criteria criteria = (Criteria)object;
                    return !criteria.isReadOnly();
                }
                throw new IllegalStateException();
            }
        }, this.isNegated());
    }

    public String toString(Event e, boolean d) {
        SyntaxStringBuilder builder = new SyntaxStringBuilder(e, d);
        builder.append(new Object[]{"scores of ", this.objects});
        builder.append((Object)(this.isNegated() ? "are not" : "are"));
        builder.append((Object)"modifiable");
        return builder.toString();
    }

    static {
        Skript.registerCondition(CondObjModifiable.class, (String[])new String[]{"[the] scores of %criterias/objectives% are modifiable", "[the] scores of %criterias/objectives% (aren't|are not) modifiable"});
    }
}

